/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.oopath;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Employee;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.After;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class OOPathLogicalBranchesTest {
    private static final KieServices KIE_SERVICES = KieServices.Factory.get();
    private KieSession kieSession;
    private List<String> results;

    @After
    public void disposeKieSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
            this.kieSession = null;
            this.results = null;
        }
    }

    @Test
    public void testBasicOrCondition() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm' || city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm' || city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Big City", "Small City"});
    }

    @Test
    public void testOrConstraint() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( $address: /address{ street == 'Elm' || city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' || city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( $address: /address{ street == 'Elm' || city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' || city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Big City", "Small City"});
    }

    @Test
    public void testOrConstraintWithJoin() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( $address: /address{ street == 'Elm' || city == 'Big City' } )\n        Employee( this != $emp, /address{ street == $address.street || city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( $address: /address{ street == 'Elm' || city == 'Big City' } )\n        Employee( this != $emp, /address{ street == $address.street || city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Big City", "Small City"});
    }

    @Test
    public void testOrConstraintNoBinding() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( /address{ street == 'Elm' || city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' || city == 'Big City' } )\nthen\n  list.add( $emp.getName() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( /address{ street == 'Elm' || city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' || city == 'Big City' } )\nthen\n  list.add( $emp.getName() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Bruno", "Alice"});
    }

    @Test
    public void testOrConditionalElement() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm', city == 'Big City' } )\n or   Employee( $address: /address{ street == 'Elm', city == 'Small City' } )\nthen\n  list.add( $address.getCity() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm', city == 'Big City' } )\n or   Employee( $address: /address{ street == 'Elm', city == 'Small City' } )\nthen\n  list.add( $address.getCity() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Big City", "Small City"});
    }

    @Test
    public void testOrConditionalElementNoBinding() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n $employee: (\n  Employee( /address{ street == 'Elm', city == 'Big City' } )\n or   Employee( /address{ street == 'Elm', city == 'Small City' } )\n )\nthen\n  list.add( $employee.getName() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n $employee: (\n  Employee( /address{ street == 'Elm', city == 'Big City' } )\n or   Employee( /address{ street == 'Elm', city == 'Small City' } )\n )\nthen\n  list.add( $employee.getName() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Bruno", "Alice"});
    }

    @Test
    public void testBasicAndCondition() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm' && city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm' && city == 'Big City' } )\nthen\n  list.add( $address.getCity() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactly((Object[])new String[]{"Big City"});
    }

    @Test
    public void testAndConstraint() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( $address: /address{ street == 'Elm' && city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' && city == 'Small City' } )\nthen\n  list.add( $address.getCity() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( $address: /address{ street == 'Elm' && city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' && city == 'Small City' } )\nthen\n  list.add( $address.getCity() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Big City"});
    }

    @Test
    public void testAndConstraintNoBinding() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( /address{ street == 'Elm' && city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' && city == 'Small City' } )\nthen\n  list.add( $emp.getName() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $emp: Employee( /address{ street == 'Elm' && city == 'Big City' } )\n        Employee( this != $emp, /address{ street == 'Elm' && city == 'Small City' } )\nthen\n  list.add( $emp.getName() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Alice"});
    }

    @Test
    public void testAndConditionalElement() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm', city == 'Big City' } )\n and   Employee( /address{ street == 'Elm', city == 'Small City' } )\nthen\n  list.add( $address.getCity() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  Employee( $address: /address{ street == 'Elm', city == 'Big City' } )\n and   Employee( /address{ street == 'Elm', city == 'Small City' } )\nthen\n  list.add( $address.getCity() );\nend\n".getBytes()));
        this.initKieSession(kieBase);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Big City"});
    }

    @Test
    public void testAndConditionalElementWithNot() {
        String drl = "import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $employee: Employee( /address{ street == 'Elm', city == 'Big City' } )\n and   not Employee( /address{ street == 'Elm', city == 'Small City' } )\nthen\n  list.add( $employee.getName() );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromDRLResources(true, KIE_SERVICES.getResources().newByteArrayResource("import org.drools.testcoverage.common.model.Employee;\nimport org.drools.testcoverage.common.model.Address;\nglobal java.util.List list\n\nrule R when\n  $employee: Employee( /address{ street == 'Elm', city == 'Big City' } )\n and   not Employee( /address{ street == 'Elm', city == 'Small City' } )\nthen\n  list.add( $employee.getName() );\nend\n".getBytes()));
        this.createKieSession(kieBase);
        Employee bruno = this.createEmployee("Bruno", new Address("Elm", 10, "Small City"));
        FactHandle brunoFactHandle = this.kieSession.insert((Object)bruno);
        Employee alice = this.createEmployee("Alice", new Address("Elm", 10, "Big City"));
        this.kieSession.insert((Object)alice);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).isEmpty();
        this.kieSession.delete(brunoFactHandle);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Alice"});
    }

    private void initKieSession(KieBase kieBase) {
        this.createKieSession(kieBase);
        this.populateKieSession();
    }

    private void createKieSession(KieBase kieBase) {
        this.kieSession = kieBase.newKieSession();
        this.results = new ArrayList<String>();
        this.kieSession.setGlobal("list", this.results);
    }

    private void populateKieSession() {
        Employee bruno = this.createEmployee("Bruno", new Address("Elm", 10, "Small City"));
        this.kieSession.insert((Object)bruno);
        Employee alice = this.createEmployee("Alice", new Address("Elm", 10, "Big City"));
        this.kieSession.insert((Object)alice);
    }

    private Employee createEmployee(String name, Address address) {
        Employee employee = new Employee(name);
        employee.setAddress(address);
        return employee;
    }
}

