/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionUtil;
import org.drools.testcoverage.common.util.Session;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class ActivationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private final KieSessionTestConfiguration kieSessionTestConfiguration;
    private Session ksession;
    private static final String DRL = "package org.drools;\nimport org.drools.testcoverage.common.model.Cheese\nimport org.drools.testcoverage.common.model.Person\n rule R1\n    salience 10\n    when\n        $c : Cheese( price == 10 )\n        $p : Person( )\n    then\n        modify($c) { setPrice( 5 ) }\n        modify($p) { setAge( 20 ) }\nend\nrule R2\n    when\n        $p : Person( )\n    then \n        // noop\nend\n";

    public ActivationTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
        this.kieSessionTestConfiguration = kieSessionTestConfiguration;
    }

    @Before
    public void createKieSession() {
        this.ksession = this.getKieSessionForTest();
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndKieSessionConfigurations();
    }

    @Test
    public void noDormantCheckOnModifies() throws Exception {
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        this.ksession.addEventListener(ael);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(KieServices.Factory.get().getCommands().newInsert((Object)new Person("Bob", 19)));
        commands.add(KieServices.Factory.get().getCommands().newInsert((Object)new Cheese("brie", 10)));
        commands.add(KieServices.Factory.get().getCommands().newFireAllRules());
        this.ksession.execute(KieServices.Factory.get().getCommands().newBatchExecution(commands, null));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)Matchers.any(AfterMatchFiredEvent.class));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).matchCancelled((MatchCancelledEvent)Matchers.any(MatchCancelledEvent.class));
    }

    private Session getKieSessionForTest() {
        return KieSessionUtil.getKieSessionAndBuildInstallModuleFromDrl("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, this.kieSessionTestConfiguration, DRL);
    }
}

