/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.compiler.TurtleTestCategory;
import org.drools.core.time.SessionPseudoClock;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsGcCausesNPETest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DroolsGcCausesNPETest.class);
    private static final String KIE_BASE_NAME = "defaultBase";
    private static final String DRL_FILE_NAME = "DroolsGcCausesNPE.drl";
    private static final KieServices SERVICES = KieServices.Factory.get();
    private static final ReleaseId RELEASE_ID = SERVICES.newReleaseId("org.drools.testcoverage", "drools-gc-causes-npe-example", "1.0");
    private KieSession session;
    private SessionPseudoClock clock;
    private FactType eventFactType;

    @BeforeClass
    public static void beforeClass() throws Exception {
        KieModuleModel module = SERVICES.newKieModuleModel();
        KieBaseModel base = module.newKieBaseModel(KIE_BASE_NAME);
        base.setEventProcessingMode(EventProcessingOption.STREAM);
        KieFileSystem fs = SERVICES.newKieFileSystem();
        fs.generateAndWritePomXML(RELEASE_ID);
        fs.write(SERVICES.getResources().newClassPathResource(DRL_FILE_NAME, DroolsGcCausesNPETest.class));
        fs.writeKModuleXML(module.toXML());
        KieBuilder builder = SERVICES.newKieBuilder(fs);
        List errors = builder.buildAll().getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assertions.assertThat((List)errors).as("Unexpected errors building drl: " + errors, new Object[0]).isEmpty();
        SERVICES.getRepository().addKieModule(builder.getKieModule());
    }

    @Before
    public void setUp() throws Exception {
        KieSessionConfiguration conf = SERVICES.newKieSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        conf.setProperty("type", "stateful");
        KieContainer container = SERVICES.newKieContainer(RELEASE_ID);
        this.session = container.getKieBase(KIE_BASE_NAME).newKieSession(conf, SERVICES.newEnvironment());
        this.clock = (SessionPseudoClock)this.session.getSessionClock();
        this.eventFactType = this.session.getKieBase().getFactType(this.getClass().getPackage().getName(), "Event");
    }

    @Test
    @Category(value={TurtleTestCategory.class})
    public void testMoreTimesRepeated() throws Exception {
        int i;
        Random r = new Random(1L);
        try {
            for (i = 0; i < 100000; ++i) {
                this.insertAndAdvanceTime(i, r.nextInt(4000));
            }
        }
        catch (NullPointerException e) {
            LOGGER.warn("failed at i = " + i);
            LOGGER.warn("fact count: " + this.session.getFactCount());
            this.logActiveFacts();
            Assertions.fail((String)"NPE thrown - consider reopening BZ 1181584", (Throwable)e);
        }
    }

    @Test
    public void test() throws Exception {
        this.insertAndAdvanceTime(1L, 4000L);
    }

    private void insertAndAdvanceTime(long id, long millis) throws IllegalAccessException, InstantiationException {
        this.insert(this.createEvent(id));
        this.advanceTime(millis);
    }

    private Object createEvent(long id) throws IllegalAccessException, InstantiationException {
        Object event = this.eventFactType.newInstance();
        this.eventFactType.set(event, "id", (Object)id);
        return event;
    }

    private void advanceTime(long millis) {
        this.clock.advanceTime(millis, TimeUnit.MILLISECONDS);
        this.session.fireAllRules();
    }

    private void insert(Object event) {
        this.session.insert(event);
        this.session.fireAllRules();
    }

    private void logActiveFacts() {
        LOGGER.warn("facts: ");
        this.session.getFactHandles().stream().map(Object::toString).forEach(arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }
}

