/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.Reader;
import java.io.StringReader;
import org.assertj.core.api.Assertions;
import org.drools.core.common.DefaultAgenda;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

public class UseOfRuleFlowGroupPlusLockOnTest {
    private static final String DRL = "package org.drools.testcoverage.regression\nimport org.drools.testcoverage.common.model.Person\nimport org.drools.testcoverage.common.model.Cheese\nrule R1\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person()\nthen\n   $p.setName(\"John\");\n   update ($p);\nend\nrule R2\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person( name == null )\n   forall ( Cheese ( type == \"cheddar\" ))\nthen\nend\n";

    @Test
    public void test() {
        Resource resource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(DRL));
        resource.setTargetPath("src/main/resources/rule.drl");
        KieBuilder kbuilder = KieUtil.getKieBuilderFromResources(true, resource);
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder(kbuilder);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person());
        ksession.insert((Object)new Cheese("eidam"));
        ((DefaultAgenda)ksession.getAgenda()).activateRuleFlowGroup("group1");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }
}

