/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

public class GuidedDecisionTableTest {
    private Address barcelonaCityCenter;
    private Person johnFromBarcelona;
    private KieSession kSession;
    private TrackingAgendaEventListener rulesFired;

    @Before
    public void setUp() throws Exception {
        this.barcelonaCityCenter = new Address("City Center", 1, "Barcelona");
        this.johnFromBarcelona = new Person("John", 18);
        this.johnFromBarcelona.setAddress(this.barcelonaCityCenter);
    }

    @Test
    public void testUniqueHitPolicy() throws Exception {
        this.initKieSession("uniqueHitPolicy.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 2 uniqueHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testUniqueHitPolicyWithSalience() throws Exception {
        this.initKieSession("uniqueHitPolicyWithSalience.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 4 uniqueHitPolicyWithSalience")).isTrue();
        this.kSession.dispose();
    }

    private void initKieSession(String gdstName) {
        Resource resource = KieServices.Factory.get().getResources().newClassPathResource(gdstName, GuidedDecisionTableTest.class);
        KieBase kBase = KieBaseUtil.getKieBaseFromResources(true, resource);
        this.kSession = kBase.newKieSession();
        this.rulesFired = new TrackingAgendaEventListener();
        this.kSession.addEventListener((AgendaEventListener)this.rulesFired);
        this.rulesFired.clear();
    }
}

