/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.ViewChangedEventListener;

public class LiveQueriesBadResultTest {
    private ArrayList<Object> inserted;
    private ArrayList<Object> updated;
    private ArrayList<Object> deleted;

    @Before
    public void initialize() {
        this.inserted = new ArrayList();
        this.updated = new ArrayList();
        this.deleted = new ArrayList();
    }

    @Test(expected=RuntimeException.class)
    public void testCallingLiveQueryWithoutParametersButItHasParams() {
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                LiveQueriesBadResultTest.this.updated.add(row.get("person"));
            }

            public void rowInserted(Row row) {
                LiveQueriesBadResultTest.this.inserted.add(row.get("person"));
            }

            public void rowDeleted(Row row) {
                LiveQueriesBadResultTest.this.deleted.add(row.get("person"));
            }
        };
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), true, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr"));
        ksession.openLiveQuery("queryWithParams", new Object[0], listener);
    }

    @Test(expected=RuntimeException.class)
    public void testBadAccessToParameterWithoutType() {
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                LiveQueriesBadResultTest.this.updated.add(row.get("person"));
            }

            public void rowInserted(Row row) {
                LiveQueriesBadResultTest.this.inserted.add(row.get("person"));
            }

            public void rowDeleted(Row row) {
                LiveQueriesBadResultTest.this.deleted.add(row.get("person"));
            }
        };
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), false, "query-bad-parametr-access.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr", 25));
        ksession.openLiveQuery("queryWithParamWithoutType", new Object[]{"Petr", 26}, listener);
    }

    @Test(expected=RuntimeException.class)
    public void testAccessToNotExistingVariable() {
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                LiveQueriesBadResultTest.this.updated.add(row.get("bad"));
            }

            public void rowInserted(Row row) {
                LiveQueriesBadResultTest.this.inserted.add(row.get("bad"));
            }

            public void rowDeleted(Row row) {
                LiveQueriesBadResultTest.this.deleted.add(row.get("bad"));
            }
        };
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), true, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr", 25));
        ksession.openLiveQuery("simple query with no parameters", new Object[]{"Petr", 26}, listener);
    }

    @Test(expected=RuntimeException.class)
    public void testOfBadListener() {
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), true, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr", 25));
        ksession.openLiveQuery("simple query with no parameters", new Object[]{"Petr", 26}, (ViewChangedEventListener)null);
    }

    @Test(expected=RuntimeException.class)
    public void testOfBadParameters() {
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                LiveQueriesBadResultTest.this.updated.add(row.get("person"));
            }

            public void rowInserted(Row row) {
                LiveQueriesBadResultTest.this.inserted.add(row.get("person"));
            }

            public void rowDeleted(Row row) {
                LiveQueriesBadResultTest.this.deleted.add(row.get("person"));
            }
        };
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), true, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr", 25));
        ksession.openLiveQuery("queryWithParamWithoutType", (Object[])null, listener);
    }
}

