/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

public class GuidedDecisionTableTest {
    private Address barcelonaCityCenter;
    private Person johnFromBarcelona;
    private Person elizabeth35Years;
    private Person william25Years;
    private Person oldPeter;
    private KieSession kSession;
    private TrackingAgendaEventListener rulesFired;

    @Before
    public void setUp() throws Exception {
        this.barcelonaCityCenter = new Address("City Center", 1, "Barcelona");
        this.johnFromBarcelona = new Person("John", 18);
        this.oldPeter = new Person("Peter", 70);
        this.johnFromBarcelona.setAddress(this.barcelonaCityCenter);
        this.elizabeth35Years = new Person("Elizabeth", 35);
        this.william25Years = new Person("William", 25);
    }

    @Test
    public void testUniqueHitPolicy() throws Exception {
        this.initKieSession("uniqueHitPolicy.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 2 uniqueHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testUniqueHitPolicyWithSalience() throws Exception {
        this.initKieSession("uniqueHitPolicyWithSalience.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 4 uniqueHitPolicyWithSalience")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testFirstHitPolicyMatchAll() throws Exception {
        this.initKieSession("firstHitPolicy.gdst");
        this.kSession.insert((Object)this.elizabeth35Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 1 firstHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testFirstHitPolicyMatchTwoOfThree() throws Exception {
        this.initKieSession("firstHitPolicy.gdst");
        this.kSession.insert((Object)this.william25Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 2 firstHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicy() throws Exception {
        this.initKieSession("resolvedHitPolicy.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 2 resolvedHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyPossibleMatchOnTwoRows() throws Exception {
        this.initKieSession("resolvedHitPolicyPossibleMatchOnTwoRows.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 6 resolvedHitPolicyPossibleMatchOnTwoRows")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyPrioritiesOverSameRow() throws Exception {
        this.initKieSession("resolvedHitPolicyPrioritiesOverSameRow.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 3 resolvedHitPolicyPrioritiesOverSameRow")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyPrioritiesOverSameRowMatchTwoRows() throws Exception {
        this.initKieSession("resolvedHitPolicyPrioritiesOverSameRowMatchTwoRows.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 5 resolvedHitPolicyPrioritiesOverSameRowMatchTwoRows")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyTransitivePriorities() throws Exception {
        this.initKieSession("resolvedHitPolicyTransitivePriorities.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 4 resolvedHitPolicyTransitivePriorities")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyTransitivePrioritiesMatchTwoRows() throws Exception {
        this.initKieSession("resolvedHitPolicyTransitivePrioritiesMatchTwoRows.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 3 resolvedHitPolicyTransitivePrioritiesMatchTwoRows")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicy() throws Exception {
        this.initKieSession("ruleOrderHitPolicy.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(4);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicy", "Row 2 ruleOrderHitPolicy", "Row 3 ruleOrderHitPolicy", "Row 4 ruleOrderHitPolicy"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyTwoOfFour() throws Exception {
        this.initKieSession("ruleOrderHitPolicy.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(2);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicy", "Row 3 ruleOrderHitPolicy"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyActivationGroupBeginning() throws Exception {
        this.initKieSession("ruleOrderHitPolicyActivationGroupBeginning.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(3);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicyActivationGroupBeginning", "Row 3 ruleOrderHitPolicyActivationGroupBeginning", "Row 4 ruleOrderHitPolicyActivationGroupBeginning"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyActivationGroupEnd() throws Exception {
        this.initKieSession("ruleOrderHitPolicyActivationGroupEnd.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(3);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicyActivationGroupEnd", "Row 2 ruleOrderHitPolicyActivationGroupEnd", "Row 3 ruleOrderHitPolicyActivationGroupEnd"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyTwoActivationGroups() throws Exception {
        this.initKieSession("ruleOrderHitPolicyTwoActivationGroups.gdst");
        this.kSession.insert((Object)this.oldPeter);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(4);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicyTwoActivationGroups", "Row 3 ruleOrderHitPolicyTwoActivationGroups", "Row 4 ruleOrderHitPolicyTwoActivationGroups", "Row 5 ruleOrderHitPolicyTwoActivationGroups"});
        this.kSession.dispose();
    }

    private void initKieSession(String gdstName) {
        Resource resource = KieServices.Factory.get().getResources().newClassPathResource(gdstName, GuidedDecisionTableTest.class);
        KieBase kBase = KieBaseUtil.getKieBaseFromResources(true, resource);
        this.kSession = kBase.newKieSession();
        this.rulesFired = new TrackingAgendaEventListener();
        this.kSession.addEventListener((AgendaEventListener)this.rulesFired);
        this.rulesFired.clear();
    }
}

