/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.core.ClockType;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.utils.KieHelper;

public class EventDeserializationInPastTest {
    @Test
    public void testSerializationWithEventInPastBZ1205666() {
        String drl = "import " + Event1.class.getCanonicalName() + "\ndeclare Event1\n @role( event )\n @timestamp( timestamp )\n @expires( 3h )\nend\n\nrule R\n when\n $evt: Event1()\n not Event1(this != $evt, this after[0, 1h] $evt)\n then\n System.out.println($evt.getCode());\nend\n";
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieHelper helper = new KieHelper();
        helper.addContent(drl, ResourceType.DRL);
        KieBase kbase = helper.build(new KieBaseOption[]{EventProcessingOption.STREAM});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        ksession.insert((Object)new Event1("id1", 0L));
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        clock.advanceTime(2L, TimeUnit.HOURS);
        ksession.fireAllRules();
        ksession = this.marshallAndUnmarshall(KieServices.Factory.get(), kbase, ksession, sessionConfig);
        ksession.insert((Object)new Event1("id2", 0L));
        ksession.fireAllRules();
    }

    private KieSession marshallAndUnmarshall(KieServices ks, KieBase kbase, KieSession ksession) {
        return this.marshallAndUnmarshall(ks, kbase, ksession, null);
    }

    private KieSession marshallAndUnmarshall(KieServices ks, KieBase kbase, KieSession ksession, KieSessionConfiguration sessionConfig) {
        Marshaller marshaller = ks.getMarshallers().newMarshaller(kbase);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            marshaller.marshall((OutputStream)baos, ksession);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
                marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
                ksession = marshaller.unmarshall((InputStream)bais, sessionConfig, null);
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"Unexpected exception: ", (Throwable)e);
        }
        return ksession;
    }

    public static class Event1
    implements Serializable {
        private final String code;
        private final long timestamp;

        public Event1(String code, long timestamp) {
            this.code = code;
            this.timestamp = timestamp;
        }

        public String getCode() {
            return this.code;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "Event1{code='" + this.code + '\'' + ", timestamp=" + this.timestamp + '}';
        }
    }
}

