/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.ClassObjectFilter;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;

@RunWith(value=Parameterized.class)
public class FromGenericCollectionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FromGenericCollectionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenerics() {
        String drl = "package org.drools.testcoverage.regression\n import java.util.Map.Entry\n import java.util.List\n import " + GenericHolder.class.getCanonicalName() + "\n rule checkCrazyMap\n when\n        GenericHolder( $map : crazyMap )\n        $entry : Entry( $list : value ) from $map.entrySet\n        $string : String ( ) from $list\n then\n        insert(new Boolean(true));\n end\n";
        KieBase kieBase = KieBaseUtil.getKieBaseAndBuildInstallModuleFromDrl("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, drl);
        KieSession ksession = kieBase.newKieSession();
        try {
            HashMap<String, List<String>> crazyMap = new HashMap<String, List<String>>();
            crazyMap.put("foo", Arrays.asList("bar"));
            GenericHolder gh = new GenericHolder();
            gh.setCrazyMap(crazyMap);
            ksession.insert((Object)gh);
            ksession.fireAllRules();
            Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Boolean.class)).size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    public static class GenericHolder {
        private Map<String, List<String>> crazyMap;

        public Map<String, List<String>> getCrazyMap() {
            return this.crazyMap;
        }

        public void setCrazyMap(Map<String, List<String>> crazyMap) {
            this.crazyMap = crazyMap;
        }
    }
}

