/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.model.Event;
import org.drools.testcoverage.common.model.EventA;
import org.drools.testcoverage.common.model.EventB;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.MessageEvent;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class FusionAfterBeforeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FusionAfterBeforeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAfterBeforeOperators() {
        Resource drlResource = KieServices.Factory.get().getResources().newClassPathResource("fusionAfterBeforeTest.drl", this.getClass());
        KieBase kieBase = KieBaseUtil.getKieBaseAndBuildInstallModule("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, drlResource);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        KieSession ksession = kieBase.newKieSession(ksconf, null);
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        EntryPoint stream = ksession.getEntryPoint("EventStream");
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        try {
            for (int i = 0; i < 3; ++i) {
                MessageEvent tc = new MessageEvent(MessageEvent.Type.received, new Message());
                stream.insert((Object)tc);
                ksession.fireAllRules();
                clock.advanceTime(8L, TimeUnit.SECONDS);
            }
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)listener.isRuleFired("AfterMessageEvent")).as("Rule 'AfterMessageEvent' was no fired!", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)listener.isRuleFired("BeforeMessageEvent")).as("Rule 'BeforeMessageEvent' was no fired!", new Object[0])).isTrue();
        int firedCount = 2;
        int actuallyFired = listener.ruleFiredCount("AfterMessageEvent");
        ((AbstractIntegerAssert)Assertions.assertThat((int)firedCount).as("Rule 'AfterMessageEvent' should be fired 2 times, but was fired " + firedCount + " time(s)!", new Object[0])).isEqualTo(actuallyFired);
        firedCount = listener.ruleFiredCount("BeforeMessageEvent");
        ((AbstractIntegerAssert)Assertions.assertThat((int)firedCount).as("Rule 'BeforeMessageEvent' should be fired 2 times, but was fired " + firedCount + " time(s)!", new Object[0])).isEqualTo(actuallyFired);
    }

    @Test(timeout=10000L)
    public void testExpireEventsWhenSharingAllRules() throws InstantiationException, IllegalAccessException {
        StringBuilder drlBuilder = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            drlBuilder.append(" import " + EventA.class.getCanonicalName() + ";\n");
            drlBuilder.append(" import " + EventB.class.getCanonicalName() + ";\n");
            drlBuilder.append(" declare " + EventA.class.getName() + " @role( event ) @duration(duration) end");
            drlBuilder.append(" declare " + EventB.class.getName() + " @role( event ) @duration(duration) end");
            drlBuilder.append(" rule R" + i + " when \n");
            drlBuilder.append("   $event1: " + EventA.class.getName() + "()\n");
            drlBuilder.append("   $event2: " + EventB.class.getName() + "(this != $event1, this after [1,10] $event1)\n");
            drlBuilder.append("then end\n");
        }
        TreeSet<Event> events = new TreeSet<Event>();
        events.addAll(this.getEvents(EventA.class, 32, 2L, 100L, 0L));
        events.addAll(this.getEvents(EventB.class, 32, 5L, 100L, 0L));
        KieSessionConfiguration sessionConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        KieSession kieSession = new KieHelper().addContent(drlBuilder.toString(), ResourceType.DRL).build(this.kieBaseTestConfiguration.getKieBaseConfiguration()).newKieSession(sessionConf, null);
        Assertions.assertThat((int)this.insertEventsAndFire(kieSession, events)).isEqualTo(2048);
    }

    private <T extends Event> SortedSet<T> getEvents(Class<T> eventClass, int eventsCount, long startTime, long timeIncrement, long duration) throws IllegalAccessException, InstantiationException {
        TreeSet<Event> resultList = new TreeSet<Event>();
        long actualTime = startTime;
        for (int i = 0; i < eventsCount; ++i) {
            Event event = (Event)eventClass.newInstance();
            event.setTimeValue(actualTime);
            event.setDuration(duration);
            resultList.add(event);
            actualTime += timeIncrement;
        }
        return resultList;
    }

    private int insertEventsAndFire(KieSession kieSession, SortedSet<Event> events) {
        SessionPseudoClock sessionClock = (SessionPseudoClock)kieSession.getSessionClock();
        long startTime = sessionClock.getCurrentTime();
        int fireCount = 0;
        for (Event event : events) {
            long eventTime = startTime + event.getTimeValue();
            sessionClock.advanceTime(eventTime - sessionClock.getCurrentTime(), TimeUnit.MILLISECONDS);
            kieSession.insert((Object)event);
            fireCount += kieSession.fireAllRules();
        }
        return fireCount;
    }
}

