/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.Reader;
import java.io.StringReader;
import org.drools.testcoverage.common.util.KieUtil;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;

public class ImportReplaceTest {
    private static final String declares = "package org.drools.testcoverage.regression.importreplace\nimport org.drools.testcoverage.common.model.Person\ndeclare SomePerson\n    person : Person\n    weight : double\n    height : double\nend\n";
    private static final String rules = "package org.drools.testcoverage.regression.importreplace\nimport org.drools.testcoverage.common.model.Person\ndeclare Holder\n    person : Person\nend\nrule \"create holder\"\n    when\n        person : Person( )\n        not (\n            Holder( person; )\n        )\n    then\n        insert(new Holder(person));\nend\n";

    @Test
    public void test() {
        Resource declaresResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(declares));
        declaresResource.setTargetPath("src/main/resources/declares.drl");
        Resource rulesResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(rules));
        rulesResource.setTargetPath("src/main/resources/rules.drl");
        KieUtil.getKieBuilderFromResources(true, declaresResource, rulesResource);
        KieUtil.getKieBuilderFromResources(true, rulesResource, declaresResource);
    }
}

