/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.Reader;
import java.io.StringReader;
import org.drools.testcoverage.common.util.KieUtil;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.definition.type.Position;
import org.kie.api.io.Resource;

public class POJOAnnotationMergeTest {
    private static final String EVENT_CLASS_NAME = PositionAnnotatedEvent.class.getCanonicalName();
    private static final String DRL = "package org.test\ndeclare " + EVENT_CLASS_NAME + "\n    @role(event)\nend \nrule 'sample rule' \nwhen \n  " + EVENT_CLASS_NAME + "( 'value1', 'value2'; )\nthen\nend\n";

    @Test
    public void testPositionFromPOJOIgnored() {
        Resource resource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(DRL));
        resource.setTargetPath("src/main/resources/rule.drl");
        KieUtil.getKieBuilderFromResources(true, resource);
    }

    public static class PositionAnnotatedEvent {
        @Position(value=1)
        private String arg1;
        @Position(value=0)
        private String arg0;

        public String getArg1() {
            return this.arg1;
        }

        public void setArg1(String arg1) {
            this.arg1 = arg1;
        }

        public String getArg0() {
            return this.arg0;
        }

        public void setArg0(String arg0) {
            this.arg0 = arg0;
        }
    }
}

