/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.Reader;
import java.io.StringReader;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KieBaseUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieBaseUtil.class);

    public static KieBase getDefaultKieBaseFromKieBuilder(KieBuilder kbuilder) {
        return KieBaseUtil.getDefaultKieBaseFromKieModule(kbuilder.getKieModule());
    }

    public static KieBase getDefaultKieBaseFromKieModule(KieModule kmodule) {
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kmodule.getReleaseId());
    }

    public static KieBase getDefaultKieBaseFromReleaseId(ReleaseId id) {
        return KieBaseUtil.getKieBaseFromReleaseIdByName(id, null);
    }

    public static KieBase getKieBaseFromClasspathResources(Class classLoaderFromClass, boolean failIfBuildError, String ... resources) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(classLoaderFromClass, failIfBuildError, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    public static KieBase getKieBaseFromResources(boolean failIfBuildError, Resource ... resources) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources(failIfBuildError, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    public static KieBase getKieBaseFromDRLResources(boolean failIfBuildError, Resource ... resources) {
        KieBaseUtil.generateDRLResourceTargetPath(resources);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources(failIfBuildError, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    private static void generateDRLResourceTargetPath(Resource[] resources) {
        for (int index = 0; index < resources.length; ++index) {
            resources[index].setTargetPath(String.format("rule-%d.drl", index));
        }
    }

    public static KieBase getKieBaseFromReleaseIdByName(ReleaseId id, String name) {
        KieContainer container = KieServices.Factory.get().newKieContainer(id);
        if (name == null) {
            return container.getKieBase();
        }
        return container.getKieBase(name);
    }

    public static KieBase getKieBaseAndBuildInstallModule(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieBaseUtil.getKieBaseAndBuildInstallModule(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources);
    }

    public static KieBase getKieBaseAndBuildInstallModule(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieModule kieModule = KieBaseUtil.getKieModuleAndBuildInstallModule(releaseId, kieBaseTestConfiguration, resources);
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kieModule.getReleaseId());
    }

    public static KieBase getKieBaseAndBuildInstallModuleFromDrl(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String drl) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return KieBaseUtil.getKieBaseAndBuildInstallModule(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, drlResource);
    }

    public static KieModule getKieModuleAndBuildInstallModuleFromDrl(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String drl) {
        return KieBaseUtil.getKieModuleAndBuildInstallModuleFromDrl(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, drl);
    }

    public static KieModule getKieModuleAndBuildInstallModuleFromDrl(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, String drl) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return KieBaseUtil.getKieModuleAndBuildInstallModule(releaseId, kieBaseTestConfiguration, drlResource);
    }

    public static KieModule getKieModuleAndBuildInstallModule(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieBaseUtil.getKieModuleAndBuildInstallModule(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources);
    }

    public static KieModule getKieModuleAndBuildInstallModule(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieModuleModel module = KieUtil.createKieModuleModel();
        kieBaseTestConfiguration.getKieBaseModel(module);
        return KieUtil.buildAndInstallKieModuleIntoRepo(releaseId, module, resources);
    }

    private KieBaseUtil() {
    }
}

