/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;

public class Session
implements CommandExecutor,
KieRuntimeEventManager {
    private KieRuntimeEventManager session;
    private final boolean stateful;
    private final boolean persisted;

    protected Session(KieRuntimeEventManager session, boolean stateful, boolean persisted) {
        this.session = session;
        this.stateful = stateful;
        this.persisted = persisted;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public StatelessKieSession getStateless() {
        if (this.isStateful()) {
            throw new IllegalStateException("This session is not stateless");
        }
        return (StatelessKieSession)this.session;
    }

    public KieSession getStateful() {
        if (!this.isStateful()) {
            throw new IllegalStateException("This session is not stateful");
        }
        return (KieSession)this.session;
    }

    public void dispose() {
        if (this.isStateful()) {
            KieSession s = this.getStateful();
            try {
                s.dispose();
            }
            catch (IllegalStateException ex) {
                Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Illegal method call. This session was previously disposed.");
            }
            finally {
                this.session = null;
            }
        } else {
            this.session = null;
        }
    }

    private CommandExecutor getCommandExecutor() {
        return (CommandExecutor)this.session;
    }

    public <T> T execute(Command<T> command) {
        return (T)this.getCommandExecutor().execute(command);
    }

    public void addEventListener(AgendaEventListener arg0) {
        this.session.addEventListener(arg0);
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.session.getAgendaEventListeners();
    }

    public void removeEventListener(AgendaEventListener arg0) {
        this.session.removeEventListener(arg0);
    }

    public void addEventListener(ProcessEventListener arg0) {
        this.session.addEventListener(arg0);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.session.getProcessEventListeners();
    }

    public void removeEventListener(ProcessEventListener arg0) {
        this.session.removeEventListener(arg0);
    }

    public void setGlobal(String identifier, Object value) {
        if (this.stateful) {
            this.getStateful().setGlobal(identifier, value);
        } else {
            this.getStateless().setGlobal(identifier, value);
        }
    }

    public KieRuntimeLogger getLogger() {
        if (this.stateful) {
            return this.getStateful().getLogger();
        }
        return this.getStateless().getLogger();
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
        if (this.stateful) {
            this.getStateful().addEventListener(listener);
        } else {
            this.getStateless().addEventListener(listener);
        }
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
        if (this.stateful) {
            this.getStateful().removeEventListener(listener);
        } else {
            this.getStateless().removeEventListener(listener);
        }
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        if (this.stateful) {
            return this.getStateful().getRuleRuntimeEventListeners();
        }
        return this.getStateless().getRuleRuntimeEventListeners();
    }
}

