/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.testcoverage.common.listener.OrderListener;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Sample;
import org.drools.testcoverage.common.model.Subject;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.ResourceUtil;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.DecisionTableInputType;

public class DecisionTableTest {
    @Test
    public void testSimpleXLS() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample.xls", this.getClass(), DecisionTableInputType.XLS);
        this.testSimpleDecisionTable(decisionTable);
    }

    @Test
    public void testSimpleCSV() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample.csv", this.getClass(), DecisionTableInputType.CSV);
        this.testSimpleDecisionTable(decisionTable);
    }

    private void testSimpleDecisionTable(Resource decisionTable) {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        KieSession session = kbase.newKieSession();
        Person person = new Person("Paul");
        person.setId(1);
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(1);
        session.insert((Object)person);
        session.fireAllRules();
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(2);
        session.dispose();
    }

    @Test
    public void testMultipleTableXLS() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("multiple_tables.xls", this.getClass(), DecisionTableInputType.XLS);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        Assertions.assertThat((int)2).isEqualTo(kbase.getKiePackages().size());
        KieSession session = kbase.newKieSession();
        Person person = new Person("Paul");
        person.setId(1);
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(1);
        Person person2 = new Person("Helmut von Seireit");
        person2.setId(1000);
        Assertions.assertThat((String)person2.getName()).isEqualTo((Object)"Helmut von Seireit");
        Assertions.assertThat((int)person2.getId()).isEqualTo(1000);
        session.insert((Object)person);
        session.insert((Object)person2);
        session.fireAllRules();
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(2);
        Assertions.assertThat((String)person2.getName()).isEqualTo((Object)"Wilhelm von Seireit");
        Assertions.assertThat((int)person2.getId()).isEqualTo(1000);
        session.dispose();
    }

    @Test
    public void testEvalTable() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("eval_dt.xls", this.getClass(), DecisionTableInputType.XLS);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        Assertions.assertThat((int)2).isEqualTo(kbase.getKiePackages().size());
        KieSession session = kbase.newKieSession();
        TrackingAgendaEventListener rulesFired = new TrackingAgendaEventListener();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject mary = new Subject("Mary");
        mary.setDummy(1);
        session.insert((Object)mary);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject inge = new Subject("Inge");
        inge.setAge(7);
        inge.setSex("F");
        Subject jochen = new Subject("Jochen");
        jochen.setAge(9);
        jochen.setSex("M");
        session.insert((Object)inge);
        session.insert((Object)jochen);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject karl = new Subject("Karl");
        karl.setSex("male");
        Subject egon = new Subject("Egon");
        egon.setSex("male");
        session.insert((Object)karl);
        session.insert((Object)egon);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject gerda = new Subject("Gerda");
        gerda.setSex("female");
        gerda.setAge(9);
        gerda.setDummy(-10);
        session.insert((Object)gerda);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Sample sample = new Sample();
        session.insert((Object)sample);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isTrue();
        session.dispose();
    }

    @Test
    public void testAdvancedTable() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("advanced_dt.xls", this.getClass(), DecisionTableInputType.XLS);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        KieSession session = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        session.addEventListener((AgendaEventListener)listener);
        Subject lili = new Subject("Lili");
        lili.setAge(100);
        Sample sample = new Sample();
        session.insert((Object)lili);
        session.insert((Object)sample);
        session.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(4);
        String[] expected = new String[]{"HelloWorld_11", "namedRule", "b1", "another rule"};
        for (int i = 0; i < 4; ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
        session.dispose();
    }

    @Test
    public void testPushQueryWithFactDeclaration() throws IllegalAccessException, InstantiationException {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("queries.xls", this.getClass(), DecisionTableInputType.XLS);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        FactType locationType = kbase.getFactType("org.drools.testcoverage.functional", "Location");
        KieSession ksession = kbase.newKieSession();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        Person peter = new Person("Peter");
        peter.setLikes("steak");
        Object steakLocation = locationType.newInstance();
        locationType.set(steakLocation, "thing", (Object)"steak");
        locationType.set(steakLocation, "location", (Object)"table");
        Object tableLocation = locationType.newInstance();
        locationType.set(tableLocation, "thing", (Object)"table");
        locationType.set(tableLocation, "location", (Object)"office");
        ksession.insert((Object)peter);
        FactHandle steakHandle = ksession.insert(steakLocation);
        FactHandle tableHandle = ksession.insert(tableLocation);
        ksession.insert((Object)"push");
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        listener.clear();
        Object steakLocation2 = locationType.newInstance();
        locationType.set(steakLocation2, "thing", (Object)"steak");
        locationType.set(steakLocation2, "location", (Object)"desk");
        Object deskLocation = locationType.newInstance();
        locationType.set(deskLocation, "thing", (Object)"desk");
        locationType.set(deskLocation, "location", (Object)"office");
        ksession.insert(steakLocation2);
        ksession.insert(deskLocation);
        ksession.delete(steakHandle);
        ksession.delete(tableHandle);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        listener.clear();
        Person paul = new Person("Paul");
        paul.setLikes("steak");
        ksession.insert((Object)paul);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        listener.clear();
        ksession.dispose();
    }

    @Test
    public void testPullQueryWithFactDeclaration() throws IllegalAccessException, InstantiationException {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("queries.xls", this.getClass(), DecisionTableInputType.XLS);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        FactType locationType = kbase.getFactType("org.drools.testcoverage.functional", "Location");
        KieSession ksession = kbase.newKieSession();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        Person peter = new Person("Peter");
        peter.setLikes("steak");
        Object steakLocation = locationType.newInstance();
        locationType.set(steakLocation, "thing", (Object)"steak");
        locationType.set(steakLocation, "location", (Object)"table");
        Object tableLocation = locationType.newInstance();
        locationType.set(tableLocation, "thing", (Object)"table");
        locationType.set(tableLocation, "location", (Object)"office");
        ksession.insert((Object)peter);
        FactHandle steakHandle = ksession.insert(steakLocation);
        FactHandle tableHandle = ksession.insert(tableLocation);
        ksession.insert((Object)"pull");
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isFalse();
        listener.clear();
        Object steakLocation2 = locationType.newInstance();
        locationType.set(steakLocation2, "thing", (Object)"steak");
        locationType.set(steakLocation2, "location", (Object)"desk");
        Object deskLocation = locationType.newInstance();
        locationType.set(deskLocation, "thing", (Object)"desk");
        locationType.set(deskLocation, "location", (Object)"office");
        ksession.insert(steakLocation2);
        ksession.insert(deskLocation);
        ksession.delete(steakHandle);
        ksession.delete(tableHandle);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isFalse();
        listener.clear();
        Person paul = new Person("Paul");
        paul.setLikes("steak");
        ksession.insert((Object)paul);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isFalse();
        listener.clear();
        ksession.dispose();
    }

    @Test
    public void testSequential() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sequential.csv", this.getClass(), DecisionTableInputType.CSV);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"something");
        ksession.fireAllRules();
        ((AbstractIntegerAssert)Assertions.assertThat((int)listener.size()).as("Wrong number of rules fired", new Object[0])).isEqualTo(3);
        String[] expected = new String[]{"Rule1", "Rule2", "Rule3"};
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
    }

    @Test
    public void testLockOnActive() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("agenda-group.csv", this.getClass(), DecisionTableInputType.CSV);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"lockOnActive");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(3);
        String[] expected = new String[]{"a", "a2", "a3"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
    }

    @Test
    public void testAutoFocus() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("agenda-group.csv", this.getClass(), DecisionTableInputType.CSV);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        FactHandle withoutAutoFocus = ksession.insert((Object)"withoutAutoFocus");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(0);
        ksession.insert((Object)"autoFocus");
        ksession.delete(withoutAutoFocus);
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected = new String[]{"b2", "b1"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
    }

    @Test
    public void testActivationGroup() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("agenda-group.csv", this.getClass(), DecisionTableInputType.CSV);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        KieSession ksession = kbase.newKieSession();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"activationGroup");
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("c1")).isFalse();
        Assertions.assertThat((boolean)listener.isRuleFired("c2")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("c3")).isFalse();
    }

    @Test(expected=DecisionTableParseException.class)
    public void testEmptyConditionInXLS() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("emptyCondition.xls", this.getClass(), DecisionTableInputType.XLS);
        KieUtil.getKieBuilderFromResources(true, decisionTable);
    }

    @Test(expected=DecisionTableParseException.class)
    public void testEmptyActionInCSV() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("emptyAction.csv", this.getClass(), DecisionTableInputType.CSV);
        KieUtil.getKieBuilderFromResources(true, decisionTable);
    }

    @Test
    public void testCSVWithDateAttributes() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample_dates.csv", this.getClass(), DecisionTableInputType.CSV);
        this.testDecisionTableWithDateAttributes(decisionTable);
    }

    @Test
    public void testXLSWithDateAttributes() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample_dates.xls", this.getClass(), DecisionTableInputType.XLS);
        this.testDecisionTableWithDateAttributes(decisionTable);
    }

    private void testDecisionTableWithDateAttributes(Resource decisionTable) {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, decisionTable);
        ArrayList<String> names = new ArrayList<String>();
        Collection pkgs = kbase.getKiePackages();
        for (KiePackage kp : pkgs) {
            names.add(kp.getName());
        }
        Assertions.assertThat((boolean)names.contains("org.drools.testcoverage.functional")).isTrue();
        Assertions.assertThat((boolean)names.contains("org.drools.testcoverage.common.model")).isTrue();
        KiePackage kiePackage = (KiePackage)pkgs.toArray()[names.indexOf("org.drools.testcoverage.functional")];
        Assertions.assertThat((int)kiePackage.getRules().size()).isEqualTo(3);
    }
}

