/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

public class QueryBadResultTest {
    @Test
    public void testQueriesWithSameNameInOneFile() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(this.getClass(), false, "query-two-same-names.drl");
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test
    public void testQueriesWithSameNameInTwoFiles() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(this.getClass(), false, "query-same-name-1.drl", "query-same-name-2.drl");
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test
    public void testQueryWithoutName() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(this.getClass(), false, "query-without-name.drl");
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test(expected=RuntimeException.class)
    public void testQueryCalledWithoutParamsButItHasParams() {
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), true, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr"));
        ksession.getQueryResults("personWithName", new Object[0]);
    }

    @Test
    public void testBadAccessToParameterWithoutType() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(this.getClass(), false, "query-bad-parametr-access.drl");
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAccessToNotExistingVariable() {
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), true, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr"));
        QueryResults results = ksession.getQueryResults("simple query with no parameters", new Object[0]);
        ((QueryResultsRow)results.iterator().next()).get("bad");
    }
}

