/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DuplicityTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DuplicityTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testTwoRulesWithSameNameInOneFile() {
        try {
            Resource resource = KieServices.Factory.get().getResources().newClassPathResource("rule-name.drl", this.getClass());
            KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, resource);
            Assertions.fail((String)"Builder should have had errors, two rules of the same name are not allowed in one file together!");
        }
        catch (AssertionError e) {
            LoggerFactory.getLogger(this.getClass()).info("", (Throwable)((Object)e));
        }
    }
}

