/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import org.drools.core.ClockType;
import org.drools.testcoverage.common.util.KieSessionModelProvider;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;

public enum KieSessionTestConfiguration implements KieSessionModelProvider
{
    STATEFUL_REALTIME(true){

        @Override
        public KieSessionModel getKieSessionModel(KieBaseModel kieBaseModel) {
            KieSessionModel kieSessionModel = kieBaseModel.newKieSessionModel(KieSessionTestConfiguration.KIE_SESSION_MODEL_NAME);
            kieSessionModel.setType(KieSessionModel.KieSessionType.STATEFUL);
            kieSessionModel.setClockType(ClockTypeOption.get((String)ClockType.REALTIME_CLOCK.toString()));
            kieSessionModel.setDefault(true);
            return kieSessionModel;
        }

        @Override
        public KieSessionConfiguration getKieSessionConfiguration() {
            KieSessionConfiguration kieSessionConfiguration = KieServices.Factory.get().newKieSessionConfiguration();
            kieSessionConfiguration.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.REALTIME_CLOCK.toString()));
            return kieSessionConfiguration;
        }
    }
    ,
    STATEFUL_PSEUDO(true){

        @Override
        public KieSessionModel getKieSessionModel(KieBaseModel kieBaseModel) {
            KieSessionModel kieSessionModel = kieBaseModel.newKieSessionModel(KieSessionTestConfiguration.KIE_SESSION_MODEL_NAME);
            kieSessionModel.setType(KieSessionModel.KieSessionType.STATEFUL);
            kieSessionModel.setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.toString()));
            kieSessionModel.setDefault(true);
            return kieSessionModel;
        }

        @Override
        public KieSessionConfiguration getKieSessionConfiguration() {
            KieSessionConfiguration kieSessionConfiguration = KieServices.Factory.get().newKieSessionConfiguration();
            kieSessionConfiguration.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.toString()));
            return kieSessionConfiguration;
        }
    }
    ,
    STATELESS_REALTIME(false){

        @Override
        public KieSessionModel getKieSessionModel(KieBaseModel kieBaseModel) {
            KieSessionModel kieSessionModel = kieBaseModel.newKieSessionModel(KieSessionTestConfiguration.KIE_SESSION_MODEL_NAME);
            kieSessionModel.setType(KieSessionModel.KieSessionType.STATELESS);
            kieSessionModel.setClockType(ClockTypeOption.get((String)ClockType.REALTIME_CLOCK.toString()));
            kieSessionModel.setDefault(true);
            return kieSessionModel;
        }

        @Override
        public KieSessionConfiguration getKieSessionConfiguration() {
            KieSessionConfiguration kieSessionConfiguration = KieServices.Factory.get().newKieSessionConfiguration();
            kieSessionConfiguration.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.REALTIME_CLOCK.toString()));
            return kieSessionConfiguration;
        }
    };

    private boolean stateful = false;
    public static final String KIE_SESSION_MODEL_NAME = "KieSessionModelName";

    public boolean isStateful() {
        return this.stateful;
    }

    private KieSessionTestConfiguration(boolean stateful) {
        this.stateful = stateful;
    }
}

