/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.core.base.ClassObjectType;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.modelcompiler.ExecutableModelFlowProject;
import org.drools.modelcompiler.ExecutableModelProject;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.KieCommands;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KieUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieUtil.class);

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, String groupId, KieModuleModel kieModuleModel, Resource ... resources) {
        ReleaseId releaseId = KieUtil.generateReleaseId(groupId);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, releaseId, kieModuleModel, resources);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, ReleaseId releaseId, KieModuleModel kieModuleModel, Resource ... resources) {
        KieFileSystem fileSystem = KieUtil.getKieFileSystemWithKieModule(kieModuleModel, releaseId, resources);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, releaseId, kieModuleModel, fileSystem);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, ReleaseId releaseId, KieModuleModel kieModuleModel, KieFileSystem kieFileSystem) {
        KieServices kieServices = KieServices.Factory.get();
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem(kieBaseTestConfiguration, kieFileSystem, true);
        KieModule kieModule = builder.getKieModule();
        kieServices.getRepository().addKieModule(kieModule);
        return kieModule;
    }

    public static KieModuleModel createKieModuleModel(Boolean alphaNetworkEnabled) {
        KieServices kieServices = KieServices.Factory.get();
        KieModuleModel kieModuleModel = kieServices.newKieModuleModel();
        if (alphaNetworkEnabled.booleanValue()) {
            kieModuleModel.setConfigurationProperty("drools.alphaNetworkCompiler", "true");
        }
        return kieModuleModel;
    }

    public static KieFileSystem getKieFileSystemWithKieModule(KieModuleModel kieModuleModel, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem fileSystem = KieServices.Factory.get().newKieFileSystem();
        fileSystem.generateAndWritePomXML(releaseId);
        for (Resource resource : resources) {
            fileSystem.write(resource);
        }
        fileSystem.writeKModuleXML(kieModuleModel.toXML());
        return fileSystem;
    }

    public static KieBuilder getKieBuilderFromKieFileSystem(KieBaseTestConfiguration kieBaseTestConfiguration, KieFileSystem fileSystem, boolean failIfBuildError) {
        return KieUtil.getKieBuilderFromFileSystemWithResources(kieBaseTestConfiguration, fileSystem, failIfBuildError, false, new Resource[0]);
    }

    public static KieBuilder getKieBuilderFromDrls(KieBaseTestConfiguration kieBaseTestConfiguration, boolean failIfBuildError, String ... drls) {
        List<Resource> resources = KieUtil.getResourcesFromDrls(drls);
        return KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, failIfBuildError, resources.toArray(new Resource[0]));
    }

    public static KieBuilder getKieBuilderFromResources(KieBaseTestConfiguration kieBaseTestConfiguration, boolean failIfBuildError, Resource ... resources) {
        return KieUtil.getKieBuilderFromFileSystemWithResources(kieBaseTestConfiguration, KieServices.Factory.get().newKieFileSystem(), failIfBuildError, true, resources);
    }

    private static KieBuilder getKieBuilderFromFileSystemWithResources(KieBaseTestConfiguration kieBaseTestConfiguration, KieFileSystem kfs, boolean failIfBuildError, Boolean writeKieModule, Resource ... resources) {
        Class<DrlProject> projectClass;
        for (Resource res : resources) {
            kfs.write(res);
        }
        KieBuilder kbuilder = KieServices.Factory.get().newKieBuilder(kfs);
        if (writeKieModule.booleanValue()) {
            KieModuleModel kproj = KieBaseUtil.getKieModuleModelWithAlphaNetworkCompiler();
            kfs.writeKModuleXML(kproj.toXML());
        }
        switch (kieBaseTestConfiguration.runType()) {
            case STANDARD_FROM_DRL: 
            case STANDARD_WITH_ALPHA_NETWORK: {
                projectClass = DrlProject.class;
                break;
            }
            case FLOW_DSL: 
            case FLOW_WITH_ALPHA_NETWORK: {
                projectClass = ExecutableModelFlowProject.class;
                break;
            }
            case PATTERN_DSL: 
            case PATTERN_WITH_ALPHA_NETWORK: {
                projectClass = ExecutableModelProject.class;
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + (Object)((Object)kieBaseTestConfiguration.runType()));
            }
        }
        kbuilder.buildAll(projectClass);
        List msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.INFO});
        if (msgs.size() > 0) {
            LOGGER.info("KieBuilder information: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.WARNING})).size() > 0) {
            LOGGER.warn("KieBuilder warnings: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).size() > 0) {
            LOGGER.error("KieBuilder errors: {}", (Object)msgs.toString());
        }
        if (failIfBuildError) {
            ((ListAssert)Assertions.assertThat((List)msgs).as(msgs.toString(), new Object[0])).isEmpty();
        }
        return kbuilder;
    }

    public static ReleaseId generateReleaseId(String groupId) {
        KieServices kieServices = KieServices.Factory.get();
        return kieServices.newReleaseId(groupId, UUID.randomUUID().toString(), "1.0.0");
    }

    public static KieBuilder getKieBuilderFromClasspathResources(KieBaseTestConfiguration kieBaseTestConfiguration, Class classLoaderFromClass, boolean failIfBuildError, String ... resources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String resource : resources) {
            result.add(KieServices.Factory.get().getResources().newClassPathResource(resource, classLoaderFromClass));
        }
        return KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, failIfBuildError, result.toArray(new Resource[0]));
    }

    public static Resource[] createResources(String drlFile, Class<?> clazz) {
        return new Resource[]{KieUtil.getResources().newClassPathResource(drlFile, clazz)};
    }

    public static Resource[] createResources(String drl) {
        Resource drlResource = KieUtil.getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return new Resource[]{drlResource};
    }

    public static KieContainer getKieContainerFromDrls(KieBaseTestConfiguration kieBaseTestConfiguration, String ... drls) {
        return KieUtil.getKieContainerFromDrls(kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, drls);
    }

    public static KieContainer getKieContainerFromDrls(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, String ... drls) {
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId(UUID.randomUUID().toString(), "test-artifact", "1.0");
        KieModule kieModule = KieUtil.getKieModuleFromDrls(releaseId, kieBaseTestConfiguration, kieSessionTestConfiguration, new HashMap<String, String>(), drls);
        return kieServices.newKieContainer(kieModule.getReleaseId());
    }

    public static KieModule getKieModuleFromDrls(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String ... drls) {
        return KieUtil.getKieModuleFromDrls(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, drls);
    }

    public static KieModule getKieModuleFromDrls(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, String ... drls) {
        return KieUtil.getKieModuleFromDrls(releaseId, kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, new HashMap<String, String>(), drls);
    }

    public static KieModule getKieModuleFromDrls(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, Map<String, String> kieModuleConfigurationProperties, String ... drls) {
        List<Resource> resources = KieUtil.getResourcesFromDrls(drls);
        return KieUtil.getKieModuleFromResources(releaseId, kieBaseTestConfiguration, kieSessionTestConfiguration, kieModuleConfigurationProperties, resources.toArray(new Resource[0]));
    }

    public static KieModule getKieModuleFromResources(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieUtil.getKieModuleFromResources(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources);
    }

    public static KieModule getKieModuleFromResources(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieUtil.getKieModuleFromResources(releaseId, kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, new HashMap<String, String>(), resources);
    }

    public static KieModule getKieModuleFromResources(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, Map<String, String> kieModuleConfigurationProperties, Resource ... resources) {
        KieModuleModel kieModuleModel = KieUtil.getKieModuleModel(kieBaseTestConfiguration, kieSessionTestConfiguration, kieModuleConfigurationProperties);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, releaseId, kieModuleModel, resources);
    }

    public static KieModuleModel getKieModuleModel(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, Map<String, String> kieModuleConfigurationProperties) {
        KieModuleModel module = KieUtil.createKieModuleModel(kieBaseTestConfiguration.useAlphaNetwork());
        kieModuleConfigurationProperties.forEach((arg_0, arg_1) -> ((KieModuleModel)module).setConfigurationProperty(arg_0, arg_1));
        KieBaseModel kieBaseModel = kieBaseTestConfiguration.getKieBaseModel(module);
        kieSessionTestConfiguration.getKieSessionModel(kieBaseModel);
        return module;
    }

    public static List<Resource> getResourcesFromDrls(String ... drls) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drls[i]));
            drlResource.setSourcePath("src/main/resources/rules" + (i + 1) + ".drl");
            resources.add(drlResource);
        }
        return resources;
    }

    public static List<Resource> getClasspathResources(String ... classpathResources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String classpathResource : classpathResources) {
            if (classpathResource == null) continue;
            resources.add(KieServices.Factory.get().getResources().newClassPathResource(classpathResource));
        }
        return resources;
    }

    public static KieCommands getCommands() {
        return KieUtil.getServices().getCommands();
    }

    public static KieResources getResources() {
        return KieUtil.getServices().getResources();
    }

    public static KieServices getServices() {
        return KieServices.Factory.get();
    }

    public static Resource getResource(String content, String path) {
        KieServices kieServices = KieServices.get();
        Resource resource = kieServices.getResources().newReaderResource((Reader)new StringReader(content));
        resource.setSourcePath(path);
        return resource;
    }

    public static ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }

    private KieUtil() {
    }
}

