/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.command.Command;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.io.Resource;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationTest
extends KieSessionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivationTest.class);
    private static final String DRL = "package org.drools;\nimport org.drools.testcoverage.common.model.Cheese;\nimport org.drools.testcoverage.common.model.Person;\nglobal org.slf4j.Logger LOGGER;\n rule R1\n    salience 10\n    when\n        $c : Cheese( price == 10 )\n        $p : Person( )\n    then\n        modify($c) { setPrice( 5 ) }\n        modify($p) { setAge( 20 ) }\nend\nrule R2\n    when\n        $p : Person( )\n    then \n        LOGGER.debug(\"noop\");\nend\n";

    public ActivationTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndKieSessionConfigurations();
    }

    @Test
    public void noDormantCheckOnModifies() throws Exception {
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        this.session.addEventListener(ael);
        this.session.setGlobal("LOGGER", LOGGER);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(KieUtil.getCommands().newInsert((Object)new Person("Bob", 19)));
        commands.add(KieUtil.getCommands().newInsert((Object)new Cheese("brie", 10)));
        commands.add(KieUtil.getCommands().newFireAllRules());
        this.session.execute(KieUtil.getCommands().newBatchExecution(commands, null));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)Matchers.any(AfterMatchFiredEvent.class));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).matchCancelled((MatchCancelledEvent)Matchers.any(MatchCancelledEvent.class));
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL);
    }
}

