/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.MyFact;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

public class AccumulateRecalculationTest {
    @Test
    public void testAccumulateWithNoLoop() {
        String drl = "import " + MyFact.class.getCanonicalName() + " ;\nrule RuleAccumulate \n  no-loop true\nwhen\n  $target: MyFact(name == \"target\")\n  $sum : Integer( ) from accumulate (\n    $v1: MyFact(name str[startsWith] \"src\", currentValue != null),\n    init ( int total = 0; ),\n    action (\n      total = total + $v1.getCurrentValue().intValue();\n      System.out.println(\"action  : plus  \" + $v1.toString() + \" then total=\" + total);\n    ),\n    reverse (\n      total = total - \n        ($v1.getPreviousValue() != null ? $v1.getPreviousValue().intValue() : $v1.getCurrentValue().intValue());\n      System.out.println(\"reverse : minus \" + $v1.toString() + \" then total=\" + total);\n    ),\n    result ( new Integer(total) )\n  );\nthen\n  System.out.println(\" Fired!! \" + drools.getRule().getName() + \" total=\" + $sum);\n  $target.setCurrentValue($sum);\n  update($target);\nend\n\nrule RuleFollowing \nwhen\n  $target: MyFact(name == \"target\") @watch(currentValue)\nthen\n  System.out.println(\" Fired!! RuleFollowing target=\" + $target.toString());\nend\n";
        this.scenario(drl);
    }

    @Test
    public void testAccumulateWithNoLoopBySum() {
        String drl = "import " + MyFact.class.getCanonicalName() + " ;\nrule RuleAccumulateSum \n  no-loop true\nwhen\n  $target: MyFact(name == \"target\");\n  $sum : Number( ) from accumulate (\n    $v1: MyFact(name str[startsWith] \"src\", $val: currentValue != null),\n    sum( $val )\n  );\nthen\n  System.out.println(\" Fired!! \" + drools.getRule().getName() + \" total=\" + $sum);\n  $target.setCurrentValue($sum.intValue());\n  update($target);\nend\n\nrule RuleFollowing \nwhen\n  $target: MyFact(name == \"target\") @watch(currentValue)\nthen\n  System.out.println(\" Fired!! RuleFollowing target=\" + $target.toString());\nend\n";
        this.scenario(drl);
    }

    @Test
    public void testCollect() {
        String drl = "import java.util.ArrayList;\n import " + MyFact.class.getCanonicalName() + " ;\nrule RuleCollect \n  no-loop true\nwhen\n  $target: MyFact(name == \"target\");\n  $list : ArrayList( size > 0 ) from collect (\n    $v1: MyFact(name str[startsWith] \"src\", $val: currentValue != null)\n  );\nthen\n  int $sum = 0;\n  for (Object obj : $list) {\n    MyFact myFact = (MyFact)obj;\n    $sum = $sum + ((MyFact)obj).getCurrentValue().intValue();\n    System.out.println(\" sum + \" + myFact.toString() + \" total is \" + $sum);\n  }\n  System.out.println(\" Fired!! \" + drools.getRule().getName() + \" total=\" + $sum);\n  $target.setCurrentValue($sum);\n  update($target);\nend\n\nrule RuleFollowing \nwhen\n  $target: MyFact(name == \"target\") @watch(currentValue)\nthen\n  System.out.println(\" Fired!! RuleFollowing target=\" + $target.toString());\nend\n";
        this.scenario(drl);
    }

    @Test
    public void testWithOutAccumulateCollect() {
        String drl = "import " + MyFact.class.getCanonicalName() + " ;\nrule RuleWithOutAccumulateCollect \n  no-loop true\nwhen\n  $target: MyFact(name == \"target\");\n  $src1 : MyFact(name str[startsWith] \"src\", currentValue != null);\n  $src2 : MyFact(hashCode() < $src1.hashCode(), name str[startsWith] \"src\", currentValue != null);\nthen\n  int $sum = $src1.getCurrentValue().intValue();\n  $sum += $src2.getCurrentValue().intValue();\n  System.out.println(\" Fired!! \" + drools.getRule().getName() + \" total=\" + $sum);\n  $target.setCurrentValue($sum);\n  update($target);\nend\n\nrule RuleFollowing \nwhen\n  $target: MyFact(name == \"target\") @watch(currentValue)\nthen\n  System.out.println(\" Fired!! RuleFollowing target=\" + $target.toString());\nend\n";
        this.scenario(drl);
    }

    private void scenario(String drl) {
        KieSession ksession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        MyFact fact0 = new MyFact("target", 0);
        MyFact fact1 = new MyFact("src1", 4);
        MyFact fact2 = new MyFact("src2", 5);
        FactHandle fh0 = ksession.insert((Object)fact0);
        FactHandle fh1 = ksession.insert((Object)fact1);
        FactHandle fh2 = ksession.insert((Object)fact2);
        int fireCount = ksession.fireAllRules();
        Assertions.assertThat((int)fact0.getCurrentValue()).isEqualTo(9);
        Assertions.assertThat((int)fireCount).isEqualTo(2);
        fact2.setCurrentValue(6);
        ksession.update(fh2, (Object)fact2);
        fireCount = ksession.fireAllRules();
        Assertions.assertThat((int)fact0.getCurrentValue()).isEqualTo(10);
        Assertions.assertThat((int)fireCount).isEqualTo(2);
    }
}

