/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.NodeMemories;
import org.drools.core.reteoo.LeftTuple;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

public class BetaMemoryLeakOnDeleteTest {
    @Test
    public void testBetaMemoryLeakOnFactDelete() {
        String drl = "rule R1 when\n    $a : Integer(this == 1)\n    $b : String()\n    $c : Integer(this == 2)\nthen \nend\nrule R2 when\n    $a : Integer(this == 1)\n    $b : String()\nthen \nend\n";
        KieSession ksession = new KieHelper().addContent("rule R1 when\n    $a : Integer(this == 1)\n    $b : String()\n    $c : Integer(this == 2)\nthen \nend\nrule R2 when\n    $a : Integer(this == 1)\n    $b : String()\nthen \nend\n", ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        FactHandle fh1 = ksession.insert((Object)1);
        FactHandle fh2 = ksession.insert((Object)"test");
        ksession.fireAllRules();
        ksession.delete(fh1);
        ksession.delete(fh2);
        ksession.fireAllRules();
        NodeMemories nodeMemories = ((InternalWorkingMemory)ksession).getNodeMemories();
        for (int i = 0; i < nodeMemories.length(); ++i) {
            Memory memory = nodeMemories.peekNodeMemory(i);
            if (memory == null || memory.getSegmentMemory() == null) continue;
            LeftTuple deleteFirst = (LeftTuple)memory.getSegmentMemory().getStagedLeftTuples().getDeleteFirst();
            Assertions.assertThat((Object)deleteFirst).isNull();
        }
    }
}

