/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.model.TestEvent;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.command.Command;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.exceptions.verification.WantedButNotInvoked;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarImportTest
extends KieSessionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarImportTest.class);
    private static final String DRL_FILE = "star_import.drl";

    public StarImportTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndKieSessionConfigurations();
    }

    @Test
    public void starImportedFactAlsoDeclaredInDRL() throws Exception {
        this.session.setGlobal("LOGGER", LOGGER);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        this.session.addEventListener(ael);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(KieUtil.getCommands().newInsert((Object)new TestEvent(1, "event 1", Integer.valueOf(0))));
        commands.add(KieUtil.getCommands().newFireAllRules());
        this.session.execute(KieUtil.getCommands().newBatchExecution(commands, null));
        try {
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)Matchers.any(AfterMatchFiredEvent.class));
        }
        catch (WantedButNotInvoked e) {
            Assertions.fail((String)"The rule does not fire. For more information see BZ 973264", (Throwable)e);
        }
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL_FILE, StarImportTest.class);
    }
}

