/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.model;

import java.io.IOException;
import org.drools.testcoverage.functional.model.BuildtimeUtil;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;

public class RulesWithInTest {
    @Test
    public void testRecreateKieBaseNewContainer() throws IOException {
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = this.createKJar(kieServices);
        kieServices.newKieContainer(releaseId).newKieBase(kieServices.newKieBaseConfiguration());
        kieServices.newKieContainer(releaseId).newKieBase(kieServices.newKieBaseConfiguration());
    }

    @Test
    public void testRecreateKieBaseReuseContainer() throws IOException {
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = this.createKJar(kieServices);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        kieContainer.newKieBase(kieServices.newKieBaseConfiguration());
        kieContainer.newKieBase(kieServices.newKieBaseConfiguration());
    }

    private ReleaseId createKJar(KieServices kieServices) throws IOException {
        String drl = "package org.drools.testcoverage.functional; \nrule \"testRule\" \nwhen \n    String(this == \"test\") \nthen \nend\n";
        Resource drlResource = kieServices.getResources().newByteArrayResource("package org.drools.testcoverage.functional; \nrule \"testRule\" \nwhen \n    String(this == \"test\") \nthen \nend\n".getBytes());
        drlResource.setResourceType(ResourceType.DRL);
        drlResource.setTargetPath("org/drools/testcoverage/functional/model/testFile.drl");
        return BuildtimeUtil.createKJarFromResources(true, drlResource);
    }
}

