/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression.mvel;

import java.util.ArrayList;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.runtime.KieSession;

public class MvelLinkageErrorTest {
    private static final String TEST_FACT = "test";
    private static final String DRL = "package " + MvelLinkageErrorTest.class.getPackage().getName() + " \ndialect \"mvel\"\nimport " + MvelLinkageErrorTest.class.getPackage().getName() + ".* \nglobal java.util.List output \nrule rule1 \n  when \n    String(NotLoadableClass: length) \n  then \n    output.add(NotLoadableClass); \nend\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMvelLinkageError() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", DRL);
        Assertions.assertThatCode(() -> ks.newKieBuilder(kfs).buildAll()).doesNotThrowAnyException();
        KieSession kieSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        try {
            ArrayList result = new ArrayList();
            kieSession.setGlobal("output", result);
            kieSession.insert((Object)TEST_FACT);
            int fired = kieSession.fireAllRules();
            ((AbstractIntegerAssert)Assertions.assertThat((int)fired).as("Unexpected number of rules fired.", new Object[0])).isEqualTo(1);
        }
        finally {
            kieSession.dispose();
        }
    }
}

