/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class NonStringCompareTest {
    private static final String genericDrl = "package org.drools.testcoverage.regression\ndeclare Fact\n    field : String\nend\nrule generic\n    when\n       Fact( field == %s )\n    then\n       // consequence\nend\n";
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NonStringCompareTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testStringCompare() throws Exception {
        this.testScenario("\"someString\"", "someString");
    }

    @Test
    public void testNonQuotedStringComapre() {
        KieBuilder kbuilder = this.build("someString");
        Assertions.assertThat((int)kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(1);
    }

    @Test
    public void testIntCompare() throws Exception {
        this.testScenario("13", "13");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScenario(String factFieldValueForDrl, String factFieldValueForTest) throws IllegalAccessException, InstantiationException {
        KieBuilder kbuilder = this.build(factFieldValueForDrl);
        Assertions.assertThat((List)kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).isEmpty();
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder(kbuilder);
        KieSession ksession = kbase.newKieSession();
        try {
            FactType type = kbase.getFactType("org.drools.testcoverage.regression", "Fact");
            Object fact = type.newInstance();
            type.set(fact, "field", (Object)factFieldValueForTest);
            ksession.insert(fact);
            int count = ksession.fireAllRules();
            Assertions.assertThat((int)count).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    private KieBuilder build(String replacement) {
        String drl = String.format(genericDrl, replacement);
        return KieUtil.getKieBuilderFromDrls(this.kieBaseTestConfiguration, false, drl);
    }
}

