/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableInstantiationTest
extends KieSessionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializableInstantiationTest.class);
    private static final String DRL = "package org.drools.testcoverage.regression;\nimport org.drools.testcoverage.regression.SerializableInstantiationTest.SerializableWrapper;\nglobal org.slf4j.Logger LOGGER;\nrule serializable\n    when\n        $holder : SerializableWrapper( original == \"hello\" )\n    then\n//        LOGGER.info(\"Works like a charm!\");\nend\n";

    public SerializableInstantiationTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndKieSessionConfigurations();
    }

    @Test
    public void testSerializableInstantiation() {
        this.session.setGlobal("LOGGER", LOGGER);
        LinkedList<Command> commands = new LinkedList<Command>();
        commands.add(KieUtil.getCommands().newInsert((Object)new SerializableWrapper((Serializable)((Object)"hello"))));
        commands.add(KieUtil.getCommands().newFireAllRules());
        for (int i = 0; i < 500; ++i) {
            this.session.execute(KieUtil.getCommands().newBatchExecution(commands));
        }
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL);
    }

    public static class SerializableWrapper
    implements Serializable {
        private final Serializable original;

        public SerializableWrapper(Serializable original) {
            this.original = original;
        }

        public Serializable getOriginal() {
            return this.original;
        }
    }
}

