/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.core.marshalling.impl.ProtobufMarshaller;
import org.drools.core.util.DroolsStreamUtils;
import org.kie.api.KieBase;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.KieSession;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SerializationHelper {
    public static <T> T serializeObject(T obj) throws IOException, ClassNotFoundException {
        return SerializationHelper.serializeObject(obj, null);
    }

    public static <T> T serializeObject(T obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return (T)DroolsStreamUtils.streamIn((byte[])DroolsStreamUtils.streamOut(obj), (ClassLoader)classLoader);
    }

    public static StatefulKnowledgeSession getSerialisedStatefulKnowledgeSession(KieSession ksession, boolean dispose) throws IOException, ClassNotFoundException {
        return SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, ksession.getKieBase(), dispose);
    }

    public static StatefulKnowledgeSession getSerialisedStatefulKnowledgeSession(KieSession ksession, KieBase kbase, boolean dispose) throws IOException, ClassNotFoundException {
        StatefulKnowledgeSession ksession2;
        byte[] b1;
        ProtobufMarshaller marshaller = (ProtobufMarshaller)MarshallerFactory.newMarshaller((KieBase)kbase, (ObjectMarshallingStrategy[])((ObjectMarshallingStrategy[])ksession.getEnvironment().get("org.kie.api.marshalling.ObjectMarshallingStrategies")));
        long time = ksession.getSessionClock().getCurrentTime();
        ksession.getEnvironment().set("org.kie.Globals", (Object)ksession.getGlobals());
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            marshaller.marshall((OutputStream)bos, ksession, time);
            b1 = bos.toByteArray();
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(b1);){
            ksession2 = marshaller.unmarshall((InputStream)bais, ksession.getSessionConfiguration(), ksession.getEnvironment());
        }
        if (dispose) {
            ksession.dispose();
        }
        return ksession2;
    }
}

