/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.List;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;

public final class KieBaseUtil {
    public static KieBase getDefaultKieBaseFromKieBuilder(KieBuilder kbuilder) {
        return KieBaseUtil.getDefaultKieBaseFromKieModule(kbuilder.getKieModule());
    }

    private static KieBase getDefaultKieBaseFromKieModule(KieModule kmodule) {
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kmodule.getReleaseId());
    }

    private static KieBase getDefaultKieBaseFromReleaseId(ReleaseId id) {
        return KieBaseUtil.getKieBaseFromReleaseIdByName(id, null);
    }

    public static KieBase getKieBaseFromClasspathResources(Class classLoaderFromClass, KieBaseTestConfiguration kieBaseTestConfiguration, String ... resources) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(kieBaseTestConfiguration, classLoaderFromClass, true, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    public static KieBase getKieBaseFromResources(KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, true, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    public static KieBase getKieBaseFromDRLResources(KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieBaseUtil.generateDRLResourceTargetPath(resources);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, true, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBuilder);
    }

    private static void generateDRLResourceTargetPath(Resource[] resources) {
        for (int index = 0; index < resources.length; ++index) {
            resources[index].setTargetPath(String.format("rule-%d.drl", index));
        }
    }

    private static KieBase getKieBaseFromReleaseIdByName(ReleaseId id, String name) {
        KieContainer container = KieServices.Factory.get().newKieContainer(id);
        if (name == null) {
            return container.getKieBase();
        }
        return container.getKieBase(name);
    }

    public static KieBase getKieBaseFromKieModuleFromResources(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieBaseUtil.getKieBaseFromKieModuleFromResources(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources);
    }

    public static KieBase getKieBaseFromKieModuleFromResources(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieModule kieModule = KieUtil.getKieModuleFromResources(releaseId, kieBaseTestConfiguration, resources);
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kieModule.getReleaseId());
    }

    public static KieBase getKieBaseFromKieModuleFromDrl(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String ... drls) {
        List<Resource> resources = KieUtil.getResourcesFromDrls(drls);
        return KieBaseUtil.getKieBaseFromKieModuleFromResources(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources.toArray(new Resource[0]));
    }

    public static KieBase getKieBaseFromClasspathResources(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String ... classpathResources) {
        List<Resource> resources = KieUtil.getClasspathResources(classpathResources);
        return KieBaseUtil.getKieBaseFromKieModuleFromResources(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources.toArray(new Resource[0]));
    }

    private KieBaseUtil() {
    }
}

