/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.oopath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.mvel.compiler.TestUtil;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.MessageEvent;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class OOPathCepTest {
    private static final String MODULE_GROUP_ID = "oopath-cep-test";
    private static final String ENTRY_POINT_NAME = "test-entry-point";
    private static final long DEFAULT_DURATION_IN_SECS = 2000L;
    private KieSession kieSession;
    private List<MessageEvent> events;
    private List<Message> messages;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathCepTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations(true);
    }

    @After
    public void disposeKieSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
            this.kieSession = null;
            this.events = null;
            this.messages = null;
        }
    }

    @Test
    public void testEventWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  MessageEvent( $message: /msg[ message == 'Hello' ] )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  MessageEvent( $message: /msg[ message == 'Hello' ] )\nthen\n  messages.add( $message );\nend\n");
        this.initKieSession(kieBase);
        this.populateAndVerifyEventCase((EntryPoint)this.kieSession);
    }

    @Test
    public void testEntryPointWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n" + String.format("  MessageEvent( $message: /msg[ message == 'Hello' ] ) from entry-point \"%s\"\n", ENTRY_POINT_NAME) + "then\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, drl);
        this.initKieSession(kieBase);
        this.populateAndVerifyEventCase(this.kieSession.getEntryPoint(ENTRY_POINT_NAME));
    }

    private void populateAndVerifyEventCase(EntryPoint entryPoint) {
        Message helloMessage = new Message("Hello");
        MessageEvent helloEvent = new MessageEvent(MessageEvent.Type.sent, helloMessage);
        entryPoint.insert((Object)helloEvent);
        MessageEvent anotherEvent = new MessageEvent(MessageEvent.Type.sent, new Message("Not a hello"));
        entryPoint.insert((Object)anotherEvent);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.messages).containsExactlyInAnyOrder((Object[])new Message[]{helloMessage});
    }

    @Test
    public void testTemporalOperatorAfterWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this after ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this after ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")), clock, 1L);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorBeforeWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this before ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this before ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")), clock, 1L);
        Message pongMessage = this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorCoincidesWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this coincides[1s] ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this coincides[1s] ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")), clock, 2L);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorDuringWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this during ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this during ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 2000L));
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 500L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorFinishesWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this finishes ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this finishes ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L), clock, 1L);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 2000L), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 1000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorFinishedByWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this finishedby ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this finishedby ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 2000L), clock, 1L);
        Message pongMessage = this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 1000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorIncludesWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this includes ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this includes ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        Message pongMessage = this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L), clock, 1L);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 500L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 500L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorMeetsWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this meets[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this meets[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")), clock, 2L);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorMetByWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this metby[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this metby[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")), clock, 2L);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorOverlapsWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this overlaps[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this overlaps[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 1L), clock, 2L);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 1L), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L), clock, 1L);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 2000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorOverlappedByWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this overlappedby[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this overlappedby[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L), clock, 1L);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 2000L), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorStartsWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this starts[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this starts[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n");
        this.initKieSessionWithPseudoClock(kieBase);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L));
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 2000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 1000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testTemporalOperatorStartedByWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this startedby[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @duration( duration )\nend\nrule R when\n  ev1: MessageEvent( /msg[ message == 'Ping' ] )\n  ev2: MessageEvent( $message: /msg[ message == 'Pong' ], this startedby[ 1s ] ev1 )\nthen\n  messages.add( $message );\nend\n");
        this.initKieSessionWithPseudoClock(kieBase);
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 2000L));
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping"), 2000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        Message pongMessage = this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Pong"), 3000L));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    @Test
    public void testLengthWindowWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) over window:length( 2 )\nthen\n  events.add( $messageEvent );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) over window:length( 2 )\nthen\n  events.add( $messageEvent );\nend\n");
        this.populateAndVerifyLengthWindowCase(kieBase);
    }

    @Test
    public void testDeclaredLengthWindowWithOOPathInRule() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\n\ndeclare window Pings\n  MessageEvent() over window:length( 2 )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) from window Pings\nthen\n  events.add( $messageEvent );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\n\ndeclare window Pings\n  MessageEvent() over window:length( 2 )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) from window Pings\nthen\n  events.add( $messageEvent );\nend\n");
        this.populateAndVerifyLengthWindowCase(kieBase);
    }

    @Test
    public void testOOPathNotAllowedInDeclaredWindow() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\n\ndeclare window Pings\n  MessageEvent( /msg[ message == 'Ping' ] ) over window:length( 2 )\nend\nrule R when\n  $messageEvent: MessageEvent() from window Pings\nthen\n  events.add( $messageEvent );\nend\n";
        TestUtil.assertDrlHasCompilationError((String)"import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\n\ndeclare window Pings\n  MessageEvent( /msg[ message == 'Ping' ] ) over window:length( 2 )\nend\nrule R when\n  $messageEvent: MessageEvent() from window Pings\nthen\n  events.add( $messageEvent );\nend\n", (int)2);
    }

    private void populateAndVerifyLengthWindowCase(KieBase kieBase) {
        this.initKieSession(kieBase);
        MessageEvent pingEvent = new MessageEvent(MessageEvent.Type.sent, new Message("Ping"));
        this.kieSession.insert((Object)pingEvent);
        MessageEvent ping2Event = new MessageEvent(MessageEvent.Type.received, new Message("Ping"));
        this.kieSession.insert((Object)ping2Event);
        MessageEvent ping3Event = new MessageEvent(MessageEvent.Type.received, new Message("Ping"));
        this.kieSession.insert((Object)ping3Event);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.events).as("The rule should have fired for 2 events", new Object[0])).contains((Object[])new MessageEvent[]{ping2Event, ping3Event});
        this.events.clear();
        MessageEvent pongEvent = new MessageEvent(MessageEvent.Type.sent, new Message("Pong"));
        this.kieSession.insert((Object)pongEvent);
        MessageEvent ping4Event = new MessageEvent(MessageEvent.Type.received, new Message("Ping"));
        this.kieSession.insert((Object)ping4Event);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.events).as("The rule should have fired for ping event only", new Object[0])).contains((Object[])new MessageEvent[]{ping4Event});
    }

    @Test
    public void testTimeWindowWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) over window:time( 3s )\nthen\n  events.add( $messageEvent );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) over window:time( 3s )\nthen\n  events.add( $messageEvent );\nend\n");
        this.populateAndVerifyTimeWindowCase(kieBase);
    }

    @Test
    public void testDeclaredTimeWindowWithOOPathInRule() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\n\ndeclare window Pings\n  MessageEvent() over window:time( 3s )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) from window Pings\nthen\n  events.add( $messageEvent );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\nend\n\ndeclare window Pings\n  MessageEvent() over window:time( 3s )\nend\nrule R when\n  $messageEvent: MessageEvent( /msg[ message == 'Ping' ] ) from window Pings\nthen\n  events.add( $messageEvent );\nend\n");
        this.populateAndVerifyTimeWindowCase(kieBase);
    }

    private void populateAndVerifyTimeWindowCase(KieBase kieBase) {
        KieSessionConfiguration sessionConfiguration = KieSessionUtil.getKieSessionConfigurationWithClock(ClockTypeOption.get((String)"pseudo"), null);
        this.initKieSession(kieBase, sessionConfiguration);
        SessionPseudoClock clock = (SessionPseudoClock)this.kieSession.getSessionClock();
        MessageEvent pingEvent = new MessageEvent(MessageEvent.Type.sent, new Message("Ping"));
        this.kieSession.insert((Object)pingEvent);
        clock.advanceTime(1L, TimeUnit.SECONDS);
        MessageEvent ping2Event = new MessageEvent(MessageEvent.Type.received, new Message("Ping"));
        this.kieSession.insert((Object)ping2Event);
        clock.advanceTime(1L, TimeUnit.SECONDS);
        MessageEvent ping3Event = new MessageEvent(MessageEvent.Type.received, new Message("Ping"));
        this.kieSession.insert((Object)ping3Event);
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.events).as("The rule should have fired for 2 events", new Object[0])).containsExactlyInAnyOrder((Object[])new MessageEvent[]{ping2Event, ping3Event});
        this.events.clear();
        MessageEvent pongEvent = new MessageEvent(MessageEvent.Type.sent, new Message("Pong"));
        this.kieSession.insert((Object)pongEvent);
        clock.advanceTime(1L, TimeUnit.SECONDS);
        MessageEvent ping4Event = new MessageEvent(MessageEvent.Type.received, new Message("Ping"));
        this.kieSession.insert((Object)ping4Event);
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.events).as("The rule should have fired for ping event only", new Object[0])).contains((Object[])new MessageEvent[]{ping4Event});
    }

    @Test
    public void testEventExplicitExpirationWithOOPath() {
        String drl = "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @expires( 2s )\nend\nrule R when\n  MessageEvent( /msg[ message == 'Ping' ] )\n  MessageEvent( $message: /msg[ message == 'Pong' ] )\nthen\n  messages.add( $message );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl(MODULE_GROUP_ID, this.kieBaseTestConfiguration, "import org.drools.testcoverage.common.model.Message;\nimport org.drools.testcoverage.common.model.MessageEvent;\nglobal java.util.List events\nglobal java.util.List messages\n\ndeclare org.drools.testcoverage.common.model.MessageEvent\n  @role( event )\n  @expires( 2s )\nend\nrule R when\n  MessageEvent( /msg[ message == 'Ping' ] )\n  MessageEvent( $message: /msg[ message == 'Pong' ] )\nthen\n  messages.add( $message );\nend\n");
        SessionPseudoClock clock = this.initKieSessionWithPseudoClock(kieBase);
        this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")), clock, 3L);
        Message pongMessage = this.insertEventAndAdvanceClock(new MessageEvent(MessageEvent.Type.sent, new Message("Pong")), clock, 1L);
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The first sequence of events should NOT make the rule fire", new Object[0])).isEmpty();
        this.insertEvent(new MessageEvent(MessageEvent.Type.sent, new Message("Ping")));
        this.kieSession.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.messages).as("The last event should make the rule fire", new Object[0])).containsExactlyInAnyOrder((Object[])new Message[]{pongMessage});
    }

    private SessionPseudoClock initKieSessionWithPseudoClock(KieBase kieBase) {
        KieSessionConfiguration sessionConfiguration = KieSessionUtil.getKieSessionConfigurationWithClock(ClockTypeOption.get((String)"pseudo"), null);
        this.initKieSession(kieBase, sessionConfiguration);
        return (SessionPseudoClock)this.kieSession.getSessionClock();
    }

    private void initKieSession(KieBase kieBase) {
        this.initKieSession(kieBase, null);
    }

    private void initKieSession(KieBase kieBase, KieSessionConfiguration kieSessionConfiguration) {
        this.kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        this.messages = new ArrayList<Message>();
        this.kieSession.setGlobal("messages", this.messages);
        this.events = new ArrayList<MessageEvent>();
        this.kieSession.setGlobal("events", this.events);
    }

    private Message insertEventAndAdvanceClock(MessageEvent messageEvent, SessionPseudoClock clock, long timeInSeconds) {
        Message result = this.insertEvent(messageEvent);
        clock.advanceTime(timeInSeconds, TimeUnit.SECONDS);
        return result;
    }

    private Message insertEvent(MessageEvent messageEvent) {
        this.kieSession.insert((Object)messageEvent);
        return messageEvent.getMsg();
    }
}

