/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKieContainer;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;

public class KieContainerDefaultsTest {
    private static final String DRL = "package defaultKBase;\n rule testRule when then end\n";
    private static final ReleaseId RELEASE_ID = KieServices.Factory.get().newReleaseId("org.drools.testcoverage", "kie-container-defaults-test", "1.0.0-SNAPSHOT");
    private KieServices kieServices;

    @Before
    public void initialize() throws IOException {
        this.kieServices = KieServices.Factory.get();
    }

    @Test
    public void testTwoKieBasesOneDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true);
        kieModule.newKieBaseModel("secondKBase").setDefault(false);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        KieBase firstKBase = kieContainer.getKieBase("firstKBase");
        KieBase secondKBase = kieContainer.getKieBase("secondKBase");
        Assertions.assertThat((Object)kieContainer.getKieBase()).isEqualTo((Object)firstKBase);
        Assertions.assertThat((Object)kieContainer.getKieBase()).isNotEqualTo((Object)secondKBase);
    }

    @Test(expected=RuntimeException.class)
    public void testTwoKieBasesNoneDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(false);
        kieModule.newKieBaseModel("secondKBase").setDefault(false);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        kieContainer.getKieBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoKieSessionsOneDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setDefault(true);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession");
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        KieSession firstKSession = kieContainer.newKieSession("firstKSession");
        KieSession secondKSession = kieContainer.newKieSession("secondKSession");
        try {
            Assertions.assertThat((Object)firstKSession).isEqualTo((Object)((InternalKieContainer)kieContainer).getKieSession());
            Assertions.assertThat((Object)secondKSession).isNotEqualTo((Object)((InternalKieContainer)kieContainer).getKieSession());
        }
        finally {
            firstKSession.dispose();
            secondKSession.dispose();
        }
    }

    @Test(expected=RuntimeException.class)
    public void testTwoKieSessionsBothDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setDefault(true);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession").setDefault(true);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        kieContainer.newKieSession();
    }

    @Test(expected=RuntimeException.class)
    public void testTwoKieSessionsNoneDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setDefault(false);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession").setDefault(false);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        kieContainer.newKieSession();
    }

    @Test(expected=RuntimeException.class)
    public void testTwoKieSessionsDefaultNotSet() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession");
        kieModule.newKieBaseModel("secondKBase").setDefault(false).newKieSessionModel("secondKSession");
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        kieContainer.newKieSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoKieSessionsOneStatelessDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession").setDefault(false);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        StatelessKieSession firstKSession = kieContainer.newStatelessKieSession("firstKSession");
        KieSession secondKSession = kieContainer.newKieSession("secondKSession");
        try {
            Assertions.assertThat((Object)firstKSession).isEqualTo((Object)((InternalKieContainer)kieContainer).getStatelessKieSession());
            Assertions.assertThat((Object)secondKSession).isNotEqualTo((Object)((InternalKieContainer)kieContainer).getStatelessKieSession());
        }
        finally {
            secondKSession.dispose();
        }
    }

    @Test
    public void testTwoStatelessKieSessionsOneDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(false);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        StatelessKieSession firstKSession = kieContainer.newStatelessKieSession("firstKSession");
        StatelessKieSession secondKSession = kieContainer.newStatelessKieSession("secondKSession");
        Assertions.assertThat((Object)firstKSession).isEqualTo((Object)((InternalKieContainer)kieContainer).getStatelessKieSession());
        Assertions.assertThat((Object)secondKSession).isNotEqualTo((Object)((InternalKieContainer)kieContainer).getStatelessKieSession());
    }

    @Test(expected=RuntimeException.class)
    public void testTwoStatelessKieSessionsBothDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        kieContainer.newStatelessKieSession();
    }

    @Test(expected=RuntimeException.class)
    public void testTwoStatelessKieSessionsNoneDefault() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(false);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(false);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        kieContainer.newStatelessKieSession();
    }

    @Test(expected=RuntimeException.class)
    public void testTwoStatelessKieSessionsDefaultNotSet() {
        KieModuleModel kieModule = this.kieServices.newKieModuleModel();
        kieModule.newKieBaseModel("firstKBase").setDefault(true).newKieSessionModel("firstKSession").setType(KieSessionModel.KieSessionType.STATELESS);
        kieModule.newKieBaseModel("secondKBase").setDefault(true).newKieSessionModel("secondKSession").setType(KieSessionModel.KieSessionType.STATELESS);
        this.buildKieModule(kieModule);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        kieContainer.newStatelessKieSession();
    }

    private void buildKieModule(KieModuleModel kieModule) {
        KieFileSystem kieFileSystem = this.kieServices.newKieFileSystem();
        kieFileSystem.generateAndWritePomXML(RELEASE_ID);
        kieFileSystem.writeKModuleXML(kieModule.toXML());
        kieFileSystem.write("src/main/resources/defaultKBase/test.drl", this.kieServices.getResources().newByteArrayResource(DRL.getBytes()));
        KieBuilder kieBuilder = this.kieServices.newKieBuilder(kieFileSystem);
        kieBuilder.buildAll();
    }
}

