/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class KieContainerTest {
    private static final String DRL = "package defaultKBase;\n rule testRule when then end\n";
    private static final String SESSION_NAME = "defaultKSession";
    private static final ReleaseId RELEASE_ID = KieServices.Factory.get().newReleaseId("org.drools.testcoverage", "kie-container-test", "1.0.0-SNAPSHOT");
    private KieServices kieServices;

    @Before
    public void initialize() throws IOException {
        this.kieServices = KieServices.Factory.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotDisposingAnotherKieSession() {
        this.createKieModule(RELEASE_ID);
        KieContainer kieContainer = this.kieServices.newKieContainer(RELEASE_ID);
        KieSession firstKSession = kieContainer.newKieSession(SESSION_NAME);
        KieSession secondKSession = kieContainer.newKieSession(SESSION_NAME);
        try {
            firstKSession.fireAllRules();
        }
        catch (IllegalStateException e) {
            Assertions.fail((String)"KieSession should not have been already disposed.", (Throwable)e);
        }
        finally {
            firstKSession.dispose();
            secondKSession.dispose();
        }
    }

    private void createKieModule(ReleaseId releaseId) {
        KieModuleModel kmodule = this.kieServices.newKieModuleModel();
        kmodule.newKieBaseModel("defaultKBase").setDefault(true).newKieSessionModel(SESSION_NAME);
        KieFileSystem kfs = this.kieServices.newKieFileSystem();
        kfs.generateAndWritePomXML(releaseId);
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write("src/main/resources/defaultKBase/test.drl", this.kieServices.getResources().newByteArrayResource(DRL.getBytes()));
        KieBuilder kbuilder = this.kieServices.newKieBuilder(kfs);
        kbuilder.buildAll();
    }
}

