/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleTemplateTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleTemplateTest.class);

    @Test
    public void testSampleCheese() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        KieServices kieServices = KieServices.Factory.get();
        Resource table = kieServices.getResources().newClassPathResource("sample_cheese.xls", this.getClass());
        Resource template = kieServices.getResources().newClassPathResource("sample_cheese.drt", this.getClass());
        String drl = null;
        try {
            drl = converter.compile(table.getInputStream(), template.getInputStream(), 2, 2);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read spreadsheet or rules stream.", e);
        }
        Resource drlResource = kieServices.getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(true, drlResource);
        Collection pkgs = kbase.getKiePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(2);
        ArrayList<String> names = new ArrayList<String>();
        for (KiePackage kp : pkgs) {
            names.add(kp.getName());
        }
        Assertions.assertThat((boolean)names.contains("org.drools.testcoverage.functional")).isTrue();
        Assertions.assertThat((boolean)names.contains("org.drools.testcoverage.common.model")).isTrue();
        KiePackage kiePackage = (KiePackage)pkgs.toArray()[names.indexOf("org.drools.testcoverage.functional")];
        Assertions.assertThat((int)kiePackage.getRules().size()).isEqualTo(2);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Cheese("stilton", 42));
        ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        ksession.dispose();
    }
}

