/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.IOException;
import java.nio.charset.Charset;
import org.drools.testcoverage.common.util.KieUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class GenericsWithModifyTest {
    private static final String DRL = "package defaultKBase;\nimport java.util.Map;\nimport java.util.HashMap;\nrule R no-loop when\n $s : String( )\nthen\n Map<String,String> a = new HashMap<String,String>();\n modify( $s ) { };\nend\n";
    private KieSession kieSession;

    @Before
    public void initialize() throws IOException {
        Resource resource = KieServices.Factory.get().getResources().newByteArrayResource(DRL.getBytes(Charset.forName("UTF-8")));
        resource.setTargetPath("src/main/resources/rule.drl");
        KieBuilder kbuilder = KieUtil.getKieBuilderFromResources(true, resource);
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(kbuilder.getKieModule().getReleaseId());
        this.kieSession = kieContainer.newKieSession();
    }

    @After
    public void dispose() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
    }

    @Test
    public void testModifyWithGenericsOnRHS() {
        this.kieSession.insert((Object)"1");
        this.kieSession.fireAllRules();
    }
}

