/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.ResourceUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableInputType;

@RunWith(value=Parameterized.class)
public class ResourcesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ResourcesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testDRL() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "aggregation.drl");
        if (!this.kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            ((AbstractLongAssert)Assertions.assertThat((long)kbase.getKiePackages().size()).as("Unexpected number of KiePackages", new Object[0])).isEqualTo(3L);
        }
        this.verifyPackageWithRules(kbase, "org.drools.testcoverage.functional", 4);
        this.verifyPackageWithImports(kbase, "org.drools.testcoverage.common.model");
    }

    @Test
    public void testDSL() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "sample.dsl", "sample.dslr");
        ((AbstractLongAssert)Assertions.assertThat((long)kbase.getKiePackages().size()).as("Unexpected number of KiePackages", new Object[0])).isEqualTo(1L);
        this.verifyPackageWithRules(kbase, "org.drools.testcoverage.functional", 1);
    }

    @Test
    public void testXLS() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "sample.xls");
        ((AbstractLongAssert)Assertions.assertThat((long)kbase.getKiePackages().size()).as("Unexpected number of packages in kbase", new Object[0])).isEqualTo(2L);
        this.verifyPackageWithRules(kbase, "org.drools.testcoverage.functional", 3);
        this.verifyPackageWithImports(kbase, "org.drools.testcoverage.common.model");
    }

    @Test
    public void testCSV() {
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample.csv", this.getClass(), DecisionTableInputType.CSV);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, decisionTable);
        ((AbstractLongAssert)Assertions.assertThat((long)kbase.getKiePackages().size()).as("Unexpected number of packages in kbase", new Object[0])).isEqualTo(2L);
        this.verifyPackageWithRules(kbase, "org.drools.testcoverage.functional", 3);
        this.verifyPackageWithImports(kbase, "org.drools.testcoverage.common.model");
    }

    @Test
    public void testRuleTemplate() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile(this.getClass().getResourceAsStream("sample_cheese.xls"), this.getClass().getResourceAsStream("sample_cheese.drt"), 2, 2);
        Resource res = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        res.setTargetPath("src/main/resources/rule.drl");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, res);
        ((AbstractLongAssert)Assertions.assertThat((long)kbase.getKiePackages().size()).as("Unexpected number of packages in kbase", new Object[0])).isEqualTo(2L);
        this.verifyPackageWithRules(kbase, "org.drools.testcoverage.functional", 2);
        this.verifyPackageWithImports(kbase, "org.drools.testcoverage.common.model");
    }

    @Test
    public void testWrongExtension() {
        String drl = "package org.drools.testcoverage.functional\nimport org.drools.testcoverage.common.model.Message\nrule sampleRule\n    when\n        $m : Message( )\n    then\nend\n";
        Resource res = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader("package org.drools.testcoverage.functional\nimport org.drools.testcoverage.common.model.Message\nrule sampleRule\n    when\n        $m : Message( )\n    then\nend\n")).setResourceType(ResourceType.DRL).setSourcePath("src/main/resources/r1.txt");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, res);
        this.verifyPackageWithRules(kbase, "org.drools.testcoverage.functional", 1);
    }

    private void verifyPackageWithRules(KieBase kbase, String packageName, int expectedRules) {
        KiePackage pack = kbase.getKiePackage(packageName);
        ((ObjectAssert)Assertions.assertThat((Object)pack).as("KiePackage with given name not found in KieBase", new Object[0])).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)pack.getName()).as("Unexpected package name", new Object[0])).isEqualTo(packageName);
        ((AbstractLongAssert)Assertions.assertThat((long)pack.getRules().size()).as("Unexpected number of rules", new Object[0])).isEqualTo((long)expectedRules);
    }

    private void verifyPackageWithImports(KieBase kbase, String packageName) {
        KiePackage pack = kbase.getKiePackage(packageName);
        ((ObjectAssert)Assertions.assertThat((Object)pack).as("KiePackage with given name not found in KieBase", new Object[0])).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)pack.getName()).as("Unexpected package name", new Object[0])).isEqualTo(packageName);
        ((AbstractLongAssert)Assertions.assertThat((long)pack.getRules().size()).as("Package with import should contain no rules", new Object[0])).isEqualTo(0L);
    }
}

