/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.modelcompiler.ExecutableModelFlowProject;
import org.drools.modelcompiler.ExecutableModelProject;
import org.drools.testcoverage.common.util.EngineTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;

public final class TestParametersUtil {
    private static final boolean TEST_WITH_ALPHA_NETWORK = Boolean.valueOf(System.getProperty("alphanetworkCompilerEnabled"));

    public static Collection<Object[]> getKieBaseConfigurations(EngineTestConfiguration ... engineConfigurations) {
        if (engineConfigurations == null || engineConfigurations.length == 0) {
            throw new IllegalArgumentException("No parameters specified! Please provide some required parameters");
        }
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (KieBaseTestConfiguration testConfiguration : KieBaseTestConfiguration.values()) {
            if (!TestParametersUtil.isTestConfigurationValid(testConfiguration, engineConfigurations)) continue;
            parameters.add(new Object[]{testConfiguration});
        }
        return parameters;
    }

    private static boolean isTestConfigurationValid(KieBaseTestConfiguration testConfiguration, EngineTestConfiguration[] engineConfigurations) {
        HashSet<EngineTestConfiguration> engineTestConfigurationSet = new HashSet<EngineTestConfiguration>(Arrays.asList(engineConfigurations));
        if (testConfiguration.isStreamMode() && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.STREAM_MODE)) {
            return false;
        }
        if (!testConfiguration.isStreamMode() && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.CLOUD_MODE)) {
            return false;
        }
        if (testConfiguration.isIdentity() && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.IDENTITY_MODE)) {
            return false;
        }
        if (!testConfiguration.isIdentity() && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.EQUALITY_MODE)) {
            return false;
        }
        if (testConfiguration.useAlphaNetworkCompiler() && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.ALPHA_NETWORK_COMPILER_TRUE)) {
            return false;
        }
        if (!testConfiguration.useAlphaNetworkCompiler() && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.ALPHA_NETWORK_COMPILER_FALSE)) {
            return false;
        }
        if (!testConfiguration.getExecutableModelProjectClass().isPresent() && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.EXECUTABLE_MODEL_OFF)) {
            return false;
        }
        if (testConfiguration.getExecutableModelProjectClass().isPresent()) {
            if (testConfiguration.getExecutableModelProjectClass().get().equals(ExecutableModelFlowProject.class) && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.EXECUTABLE_MODEL_FLOW)) {
                return false;
            }
            if (testConfiguration.getExecutableModelProjectClass().get().equals(ExecutableModelProject.class) && !engineTestConfigurationSet.contains((Object)EngineTestConfiguration.EXECUTABLE_MODEL_PATTERN)) {
                return false;
            }
        }
        return true;
    }

    public static Collection<Object[]> getKieBaseConfigurations() {
        List<EngineTestConfiguration> engineTestConfigurations = Arrays.stream(EngineTestConfiguration.values()).filter(config -> (TEST_WITH_ALPHA_NETWORK || config != EngineTestConfiguration.ALPHA_NETWORK_COMPILER_TRUE) && config != EngineTestConfiguration.EQUALITY_MODE).collect(Collectors.toList());
        return TestParametersUtil.getKieBaseConfigurations(engineTestConfigurations.toArray(new EngineTestConfiguration[0]));
    }

    public static Collection<Object[]> getKieBaseStreamConfigurations(boolean testAlsoExecutableModel) {
        return TestParametersUtil.getKieBaseStreamOrCloudConfigurations(EngineTestConfiguration.STREAM_MODE, testAlsoExecutableModel);
    }

    public static Collection<Object[]> getKieBaseCloudConfigurations(boolean testAlsoExecutableModel) {
        return TestParametersUtil.getKieBaseStreamOrCloudConfigurations(EngineTestConfiguration.CLOUD_MODE, testAlsoExecutableModel);
    }

    private static Collection<Object[]> getKieBaseStreamOrCloudConfigurations(EngineTestConfiguration streamOrCloudConfig, boolean testAlsoExecutableModel) {
        ArrayList<EngineTestConfiguration> engineTestConfigurations = new ArrayList<EngineTestConfiguration>();
        engineTestConfigurations.add(streamOrCloudConfig);
        engineTestConfigurations.add(EngineTestConfiguration.IDENTITY_MODE);
        engineTestConfigurations.add(EngineTestConfiguration.EXECUTABLE_MODEL_OFF);
        engineTestConfigurations.add(EngineTestConfiguration.ALPHA_NETWORK_COMPILER_FALSE);
        if (TEST_WITH_ALPHA_NETWORK) {
            engineTestConfigurations.add(EngineTestConfiguration.ALPHA_NETWORK_COMPILER_TRUE);
        }
        if (testAlsoExecutableModel) {
            engineTestConfigurations.add(EngineTestConfiguration.EXECUTABLE_MODEL_FLOW);
            engineTestConfigurations.add(EngineTestConfiguration.EXECUTABLE_MODEL_PATTERN);
        }
        return TestParametersUtil.getKieBaseConfigurations(engineTestConfigurations.toArray(new EngineTestConfiguration[0]));
    }

    public static Collection<Object[]> getKieBaseCloudOnlyExecModelConfiguration() {
        ArrayList<EngineTestConfiguration> engineTestConfigurations = new ArrayList<EngineTestConfiguration>();
        engineTestConfigurations.add(EngineTestConfiguration.CLOUD_MODE);
        engineTestConfigurations.add(EngineTestConfiguration.IDENTITY_MODE);
        engineTestConfigurations.add(EngineTestConfiguration.ALPHA_NETWORK_COMPILER_FALSE);
        engineTestConfigurations.add(EngineTestConfiguration.EXECUTABLE_MODEL_FLOW);
        engineTestConfigurations.add(EngineTestConfiguration.EXECUTABLE_MODEL_PATTERN);
        return TestParametersUtil.getKieBaseConfigurations(engineTestConfigurations.toArray(new EngineTestConfiguration[0]));
    }

    public static Collection<Object[]> getKieBaseAndKieSessionConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        Collection<Object[]> kieBaseConfigurations = TestParametersUtil.getKieBaseCloudConfigurations(true);
        for (KieSessionTestConfiguration kieSessionTestConfiguration : KieSessionTestConfiguration.values()) {
            for (Object[] kieBaseConfigWrapped : kieBaseConfigurations) {
                parameters.add(new Object[]{kieBaseConfigWrapped[0], kieSessionTestConfiguration});
            }
        }
        kieBaseConfigurations = TestParametersUtil.getKieBaseStreamConfigurations(true);
        for (Object[] kieBaseConfigWrapped : kieBaseConfigurations) {
            parameters.add(new Object[]{kieBaseConfigWrapped[0], KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{kieBaseConfigWrapped[0], KieSessionTestConfiguration.STATEFUL_PSEUDO});
        }
        return parameters;
    }

    public static Collection<Object[]> getKieBaseAndStatefulKieSessionConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        Collection<Object[]> kieBaseConfigurations = TestParametersUtil.getKieBaseConfigurations();
        for (Object[] kieBaseConfigWrapped : kieBaseConfigurations) {
            parameters.add(new Object[]{kieBaseConfigWrapped[0], KieSessionTestConfiguration.STATEFUL_REALTIME});
            if (!((KieBaseTestConfiguration)kieBaseConfigWrapped[0]).isStreamMode()) continue;
            parameters.add(new Object[]{kieBaseConfigWrapped[0], KieSessionTestConfiguration.STATEFUL_PSEUDO});
        }
        return parameters;
    }

    public static Collection<Object[]> getStreamKieBaseAndStatefulKieSessionConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        Collection<Object[]> kieBaseConfigurations = TestParametersUtil.getKieBaseStreamConfigurations(true);
        for (Object[] kieBaseConfigWrapped : kieBaseConfigurations) {
            parameters.add(new Object[]{kieBaseConfigWrapped[0], KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{kieBaseConfigWrapped[0], KieSessionTestConfiguration.STATEFUL_PSEUDO});
        }
        return parameters;
    }

    private TestParametersUtil() {
    }
}

