/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class EscapesInMetadataTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapesInMetadataTest.class);
    private static final String RULE_NAME = "hello world";
    private static final String RULE_KEY = "output";
    private static final String RULE_VALUE = "Hello world!";
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EscapesInMetadataTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testMetadataEscapes() {
        String rule = "package org.drools.testcoverage.regression\n rule \"hello world\"\n @output(\"\\\"Hello world!\\\"\")\n when\n then\n     System.out.println(\"Hello world!\");\n end";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, "package org.drools.testcoverage.regression\n rule \"hello world\"\n @output(\"\\\"Hello world!\\\"\")\n when\n then\n     System.out.println(\"Hello world!\");\n end");
        Map metadata = kieBase.getRule("org.drools.testcoverage.regression", RULE_NAME).getMetaData();
        LOGGER.debug("package org.drools.testcoverage.regression\n rule \"hello world\"\n @output(\"\\\"Hello world!\\\"\")\n when\n then\n     System.out.println(\"Hello world!\");\n end");
        Assertions.assertThat((boolean)metadata.containsKey(RULE_KEY)).isTrue();
        Assertions.assertThat(metadata.get(RULE_KEY)).isEqualTo((Object)"\"Hello world!\"");
    }
}

