/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.StockTick;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;

@RunWith(value=Parameterized.class)
public class DeserializationWithCompositeTriggerTest {
    private static final String DRL = "package org.drools.test;\nimport org.drools.mvel.compiler.StockTick;\nglobal java.util.List list;\n\ndeclare StockTick\n @role( event )\n @expires( 1s )\nend\n\nrule \"One\"\nwhen\n $event : StockTick( )\n not StockTick( company == \"BBB\", this after[0,96h] $event )\n not StockTick( company == \"CCC\", this after[0,96h] $event )\nthen\nend\n";
    private KieSession ksession;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DeserializationWithCompositeTriggerTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Before
    public void prepare() {
        KieBuilder kbuilder = KieUtil.getKieBuilderFromDrls(this.kieBaseTestConfiguration, true, DRL);
        KieContainer kcontainer = KieServices.Factory.get().newKieContainer(kbuilder.getKieModule().getReleaseId());
        KieBaseConfiguration kieBaseConfiguration = KieServices.Factory.get().newKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieSessionConfiguration kieSessionConfiguration = KieServices.Factory.get().newKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieBase kbase = kcontainer.newKieBase(kieBaseConfiguration);
        this.ksession = kbase.newKieSession(kieSessionConfiguration, null);
    }

    @After
    public void cleanup() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testSerializationAndDeserialization() throws Exception {
        this.ksession.insert((Object)new StockTick(2L, "AAA", 1.0, 0L));
        this.ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)this.ksession, (boolean)true, (boolean)false);
        Assertions.assertThat((Object)this.ksession).isNotNull();
    }
}

