/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class SessionInsertMultiThreadingTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionInsertMultiThreadingTest.class);
    private static final int THREADS = 50;
    private static final int RUNS_PER_THREAD = 100;
    private KieBase kbase;
    private ExecutorService executor;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SessionInsertMultiThreadingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Before
    public void createExecutor() {
        Resource resource = KieServices.Factory.get().getResources().newClassPathResource("sessionInsertMultithreadingTest.drl", SessionInsertMultiThreadingTest.class);
        this.kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resource);
        this.executor = Executors.newFixedThreadPool(50);
    }

    @After
    public void shutdownExecutor() throws Exception {
        if (this.kbase != null) {
            for (KieSession ksession : this.kbase.getKieSessions()) {
                ksession.dispose();
            }
        }
        this.executor.shutdown();
        if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
            LOGGER.warn("Executor not shut down in 30s!");
            this.executor.shutdownNow();
        }
        this.executor = null;
    }

    @Test
    public void testCommonBase() throws Exception {
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 50; ++j) {
                futures.add(this.executor.submit(new KieBaseRunnable(this.kbase)));
            }
        }
        this.waitForCompletion(futures);
    }

    @Test
    public void testCommonSession() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.testSingleCommonSession();
        }
    }

    private void testSingleCommonSession() throws Exception {
        ArrayList futures = new ArrayList();
        KieSession ksession = this.kbase.newKieSession();
        try {
            this.runTestBySeveralThreads(ksession, futures);
            this.waitForCompletion(futures);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    @Test
    public void testCommonStatelessSessionBZ1187070() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.testSingleCommonStatelessSession();
        }
    }

    private void testSingleCommonStatelessSession() throws Exception {
        ArrayList futures = new ArrayList();
        StatelessKieSession statelessKieSession = this.kbase.newStatelessKieSession();
        this.runTestBySeveralThreads(statelessKieSession, futures);
        this.waitForCompletion(futures);
    }

    private void runTestBySeveralThreads(KieSession ksession, List<Future<?>> futures) throws Exception {
        for (int j = 0; j < 50; ++j) {
            futures.add(this.executor.submit(new KieSessionRunnable(ksession)));
        }
    }

    private void runTestBySeveralThreads(StatelessKieSession statelessKieSession, List<Future<?>> futures) throws Exception {
        for (int j = 0; j < 50; ++j) {
            futures.add(this.executor.submit(new StatelessKieSessionRunnable(statelessKieSession)));
        }
    }

    private void waitForCompletion(List<Future<?>> futures) throws Exception {
        Exception lastException = null;
        for (Future<?> future : futures) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public static class KieBaseRunnable
    extends KieSessionRunnable {
        public KieBaseRunnable(KieBase kbase) {
            super(kbase.newKieSession());
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                this.ksession.dispose();
            }
        }
    }

    public static class KieSessionRunnable
    implements Runnable {
        protected final KieSession ksession;

        public KieSessionRunnable(KieSession ksession) {
            this.ksession = ksession;
        }

        @Override
        public void run() {
            Message m = new Message();
            Person p = new Person();
            this.ksession.insert((Object)m);
            this.ksession.insert((Object)p);
            this.ksession.fireAllRules();
            Assertions.assertThat((String)p.getName()).isNotNull();
            Assertions.assertThat((String)m.getMessage()).isNotNull();
        }
    }

    public static class StatelessKieSessionRunnable
    implements Runnable {
        protected final StatelessKieSession statelessKieSession;

        public StatelessKieSessionRunnable(StatelessKieSession statelessKieSession) {
            this.statelessKieSession = statelessKieSession;
        }

        @Override
        public void run() {
            Message m = new Message();
            Person p = new Person();
            KieCommands kieCommands = KieServices.Factory.get().getCommands();
            ArrayList<Command> commandList = new ArrayList<Command>();
            commandList.add(kieCommands.newInsert((Object)m));
            commandList.add(kieCommands.newInsert((Object)p));
            commandList.add(kieCommands.newFireAllRules());
            this.statelessKieSession.execute((Command)kieCommands.newBatchExecution(commandList));
            Assertions.assertThat((String)p.getName()).isNotNull();
            Assertions.assertThat((String)m.getMessage()).isNotNull();
        }
    }
}

