/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.Collection;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class GuidedDecisionTableTest {
    private Address barcelonaCityCenter;
    private Address cottageInMountains;
    private Address cottageInDesert;
    private Person johnFromBarcelona;
    private Person elizabeth35Years;
    private Person william25Years;
    private Person peter70Years;
    private Person mary33Years;
    private KieSession kSession;
    private TrackingAgendaEventListener rulesFired;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public GuidedDecisionTableTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Before
    public void setUp() throws Exception {
        this.barcelonaCityCenter = new Address("City Center", 1, "Barcelona");
        this.cottageInMountains = new Address("Mountains", 999, "Small Village");
        this.cottageInDesert = new Address("Sand Street", 1, "Desert Town");
        this.johnFromBarcelona = new Person("John", 18);
        this.peter70Years = new Person("Peter", 70);
        this.mary33Years = new Person("Mary", 33);
        this.johnFromBarcelona.setAddress(this.barcelonaCityCenter);
        this.elizabeth35Years = new Person("Elizabeth", 35);
        this.william25Years = new Person("William", 25);
    }

    @Test
    public void testUniqueHitPolicy() throws Exception {
        this.initKieSession("uniqueHitPolicy.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 2 uniqueHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testUniqueHitPolicyWithSalience() throws Exception {
        this.initKieSession("uniqueHitPolicyWithSalience.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 4 uniqueHitPolicyWithSalience")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testFirstHitPolicyMatchAll() throws Exception {
        this.initKieSession("firstHitPolicy.gdst");
        this.kSession.insert((Object)this.elizabeth35Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 1 firstHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testFirstHitPolicyMatchTwoOfThree() throws Exception {
        this.initKieSession("firstHitPolicy.gdst");
        this.kSession.insert((Object)this.william25Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 2 firstHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicy() throws Exception {
        this.initKieSession("resolvedHitPolicy.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 2 resolvedHitPolicy")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyPossibleMatchOnTwoRows() throws Exception {
        this.initKieSession("resolvedHitPolicyPossibleMatchOnTwoRows.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 6 resolvedHitPolicyPossibleMatchOnTwoRows")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyPrioritiesOverSameRow() throws Exception {
        this.initKieSession("resolvedHitPolicyPrioritiesOverSameRow.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 3 resolvedHitPolicyPrioritiesOverSameRow")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyPrioritiesOverSameRowMatchTwoRows() throws Exception {
        this.initKieSession("resolvedHitPolicyPrioritiesOverSameRowMatchTwoRows.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 5 resolvedHitPolicyPrioritiesOverSameRowMatchTwoRows")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyTransitivePriorities() throws Exception {
        this.initKieSession("resolvedHitPolicyTransitivePriorities.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 4 resolvedHitPolicyTransitivePriorities")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testResolvedHitPolicyTransitivePrioritiesMatchTwoRows() throws Exception {
        this.initKieSession("resolvedHitPolicyTransitivePrioritiesMatchTwoRows.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.rulesFired.isRuleFired("Row 3 resolvedHitPolicyTransitivePrioritiesMatchTwoRows")).isTrue();
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicy() throws Exception {
        this.initKieSession("ruleOrderHitPolicy.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(4);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicy", "Row 2 ruleOrderHitPolicy", "Row 3 ruleOrderHitPolicy", "Row 4 ruleOrderHitPolicy"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyTwoOfFour() throws Exception {
        this.initKieSession("ruleOrderHitPolicy.gdst");
        this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(2);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicy", "Row 3 ruleOrderHitPolicy"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyActivationGroupBeginning() throws Exception {
        this.initKieSession("ruleOrderHitPolicyActivationGroupBeginning.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(3);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicyActivationGroupBeginning", "Row 3 ruleOrderHitPolicyActivationGroupBeginning", "Row 4 ruleOrderHitPolicyActivationGroupBeginning"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyActivationGroupEnd() throws Exception {
        this.initKieSession("ruleOrderHitPolicyActivationGroupEnd.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(3);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicyActivationGroupEnd", "Row 2 ruleOrderHitPolicyActivationGroupEnd", "Row 3 ruleOrderHitPolicyActivationGroupEnd"});
        this.kSession.dispose();
    }

    @Test
    public void testRuleOrderHitPolicyTwoActivationGroups() throws Exception {
        this.initKieSession("ruleOrderHitPolicyTwoActivationGroups.gdst");
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((int)this.rulesFired.getFiredRules().size()).isEqualTo(4);
        Assertions.assertThat(this.rulesFired.getRulesFiredOrder()).containsSequence((Object[])new String[]{"Row 1 ruleOrderHitPolicyTwoActivationGroups", "Row 3 ruleOrderHitPolicyTwoActivationGroups", "Row 4 ruleOrderHitPolicyTwoActivationGroups", "Row 5 ruleOrderHitPolicyTwoActivationGroups"});
        this.kSession.dispose();
    }

    @Test
    public void testOptimizeAddressesRemoveUnusedAddresses() throws Exception {
        this.initKieSession("optimizeAddresses.gdst");
        FactHandle cottage = this.kSession.insert((Object)this.cottageInMountains);
        FactHandle barcelona = this.kSession.insert((Object)this.barcelonaCityCenter);
        FactHandle john = this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((Object)this.kSession.getObject(cottage)).isNull();
        Assertions.assertThat((Object)this.kSession.getObject(barcelona)).isNotNull();
        Assertions.assertThat((Object)this.kSession.getObject(john)).isNotNull();
        this.kSession.dispose();
    }

    @Test
    public void testOptimizeAddressesMovePeopleToUnusedAddressOrBrno() throws Exception {
        this.initKieSession("optimizeAddresses.gdst");
        FactHandle mountainsCottage = this.kSession.insert((Object)this.cottageInMountains);
        FactHandle elizabeth = this.kSession.insert((Object)this.elizabeth35Years);
        FactHandle william = this.kSession.insert((Object)this.william25Years);
        FactHandle john = this.kSession.insert((Object)this.johnFromBarcelona);
        this.kSession.fireAllRules();
        Assertions.assertThat((Object)this.kSession.getObject(mountainsCottage)).isNotNull();
        Assertions.assertThat((Object)this.kSession.getObject(elizabeth)).isNotNull();
        Assertions.assertThat((Object)this.kSession.getObject(william)).isNotNull();
        Assertions.assertThat((Object)((Person)this.kSession.getObject(elizabeth)).getAddress()).isEqualTo((Object)this.cottageInMountains);
        Assertions.assertThat((String)((Person)this.kSession.getObject(william)).getAddress().getCity()).isEqualTo("Brno");
        Assertions.assertThat((Object)this.kSession.getObject(john)).isNotNull();
        this.kSession.dispose();
    }

    @Test
    public void testOptimizeAddressesMovePeopleAndRemoveUnusedAddresses() throws Exception {
        this.initKieSession("optimizeAddresses.gdst");
        FactHandle desertCottage = this.kSession.insert((Object)this.cottageInDesert);
        FactHandle mountainsCottage = this.kSession.insert((Object)this.cottageInMountains);
        FactHandle elizabeth = this.kSession.insert((Object)this.elizabeth35Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((Object)this.kSession.getObject(mountainsCottage)).isNotNull();
        Assertions.assertThat((Object)this.kSession.getObject(elizabeth)).isNotNull();
        Assertions.assertThat((Object)((Person)this.kSession.getObject(elizabeth)).getAddress()).isEqualTo((Object)this.cottageInMountains);
        Assertions.assertThat((Object)this.kSession.getObject(desertCottage)).isNull();
        this.kSession.dispose();
    }

    @Test
    public void testDetectWhatPersonLikesAndMoveConditionsMet() throws Exception {
        this.initKieSession("detectWhatPersonLikesAndMove.gdst");
        this.william25Years.setLikes("wine");
        FactHandle williamLikesWine = this.kSession.insert((Object)this.william25Years);
        this.elizabeth35Years.setLikes("movies");
        FactHandle elizabetLikesMovies = this.kSession.insert((Object)this.elizabeth35Years);
        this.mary33Years.setLikes("pc games");
        FactHandle maryLikesGames = this.kSession.insert((Object)this.mary33Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((String)((Person)this.kSession.getObject(williamLikesWine)).getAddress().getCity()).isEqualTo("Paris");
        Assertions.assertThat((String)((Person)this.kSession.getObject(elizabetLikesMovies)).getAddress().getCity()).isEqualTo("New York");
        Assertions.assertThat((String)((Person)this.kSession.getObject(maryLikesGames)).getAddress().getCity()).isEqualTo("Berlin");
        this.kSession.dispose();
    }

    @Test
    public void testDetectWhatPersonLikesAndMoveConditionsNotMet() throws Exception {
        this.initKieSession("detectWhatPersonLikesAndMove.gdst");
        this.william25Years.setLikes("money");
        FactHandle williamLikesMoney = this.kSession.insert((Object)this.william25Years);
        this.mary33Years.setLikes("cheese");
        FactHandle maryLikesCheese = this.kSession.insert((Object)this.mary33Years);
        this.peter70Years.setLikes("movies");
        FactHandle peterLikesMovies = this.kSession.insert((Object)this.peter70Years);
        this.kSession.fireAllRules();
        Assertions.assertThat((Object)((Person)this.kSession.getObject(williamLikesMoney)).getAddress()).isNull();
        Assertions.assertThat((Object)((Person)this.kSession.getObject(maryLikesCheese)).getAddress()).isNull();
        Assertions.assertThat((Object)((Person)this.kSession.getObject(peterLikesMovies)).getAddress()).isNull();
        this.kSession.dispose();
    }

    @Test
    public void testMoveToBiggerCities() throws Exception {
        this.initKieSession("moveToBiggerCities.gdst");
        Address brno = this.producePeopleInCity("Brno", 7000);
        Address prague = this.producePeopleInCity("Prague", 30000);
        Address london = this.producePeopleInCity("London", 60000);
        Address smallCity = new Address();
        smallCity.setCity("city with just one person");
        this.peter70Years.setAddress(smallCity);
        this.peter70Years.setLikes("big city");
        this.william25Years.setAddress(brno);
        this.william25Years.setLikes("big city");
        this.mary33Years.setAddress(prague);
        this.mary33Years.setLikes("big city");
        this.elizabeth35Years.setAddress(london);
        this.elizabeth35Years.setLikes("big city");
        this.kSession.insert((Object)smallCity);
        FactHandle peter = this.kSession.insert((Object)this.peter70Years);
        FactHandle wiliam = this.kSession.insert((Object)this.william25Years);
        FactHandle mary = this.kSession.insert((Object)this.mary33Years);
        FactHandle elizabeth = this.kSession.insert((Object)this.elizabeth35Years);
        Assertions.assertThat((int)this.kSession.fireAllRules()).isEqualTo(3);
        Assertions.assertThat((String)((Person)this.kSession.getObject(peter)).getAddress().getCity()).isEqualTo("Brno");
        Assertions.assertThat((String)((Person)this.kSession.getObject(wiliam)).getAddress().getCity()).isEqualTo("Prague");
        Assertions.assertThat((String)((Person)this.kSession.getObject(mary)).getAddress().getCity()).isEqualTo("London");
        Assertions.assertThat((String)((Person)this.kSession.getObject(elizabeth)).getAddress().getCity()).isEqualTo("London");
        this.kSession.dispose();
    }

    @Test
    public void testMoveToBiggerCitiesPeopleNotLikeBigCities() throws Exception {
        this.initKieSession("moveToBiggerCities.gdst");
        Address brno = this.producePeopleInCity("Brno", 7000);
        Address prague = this.producePeopleInCity("Prague", 30000);
        Address london = this.producePeopleInCity("London", 60000);
        Address smallCity = new Address();
        smallCity.setCity("city with just one person");
        this.peter70Years.setAddress(smallCity);
        this.william25Years.setAddress(brno);
        this.mary33Years.setAddress(prague);
        this.elizabeth35Years.setAddress(london);
        this.kSession.insert((Object)smallCity);
        this.kSession.insert((Object)this.peter70Years);
        this.kSession.insert((Object)this.william25Years);
        this.kSession.insert((Object)this.mary33Years);
        this.kSession.insert((Object)this.elizabeth35Years);
        Assertions.assertThat((int)this.kSession.fireAllRules()).isEqualTo(0);
        this.kSession.dispose();
    }

    @Test
    public void testMoveToBiggerCitiesTooBigGapBetweenCitySizes() throws Exception {
        this.initKieSession("moveToBiggerCities.gdst");
        Address brno = this.producePeopleInCity("Brno", 7000);
        this.producePeopleInCity("London", 60000);
        this.william25Years.setAddress(brno);
        this.william25Years.setLikes("big city");
        this.kSession.insert((Object)this.william25Years);
        Assertions.assertThat((int)this.kSession.fireAllRules()).isEqualTo(0);
        this.kSession.dispose();
    }

    @Test
    public void testMoveToPeopleToAddress() throws Exception {
        this.initKieSession("person_actions.dsl", "movePeopleToAddress.gdst");
        Address technologyPark = new Address();
        technologyPark.setCity("Brno");
        technologyPark.setStreet("Technology Park");
        technologyPark.setNumber(1);
        this.kSession.insert((Object)technologyPark);
        this.peter70Years.setAddress(technologyPark);
        this.william25Years.setAddress(technologyPark);
        FactHandle peter = this.kSession.insert((Object)this.peter70Years);
        FactHandle william = this.kSession.insert((Object)this.william25Years);
        Assertions.assertThat((int)this.kSession.fireAllRules()).isEqualTo(1);
        Assertions.assertThat((String)((Person)this.kSession.getObject(peter)).getAddress().getStreet()).isEqualTo("Jo\u0161tova");
        Assertions.assertThat((String)((Person)this.kSession.getObject(william)).getAddress().getStreet()).isEqualTo("Technology Park");
        this.kSession.dispose();
    }

    private Address producePeopleInCity(String city, int countOfPeople) {
        Address address = new Address();
        address.setCity(city);
        this.kSession.insert((Object)address);
        for (int i = 0; i < countOfPeople; ++i) {
            Person person = new Person();
            person.setName("Inhabitant " + i);
            person.setAddress(address);
            this.kSession.insert((Object)person);
        }
        return address;
    }

    private void initKieSession(String ... resourceNames) {
        KieResources kieResources = KieServices.get().getResources();
        Resource[] resources = (Resource[])Stream.of(resourceNames).map(resource -> kieResources.newClassPathResource(resource, GuidedDecisionTableTest.class)).toArray(Resource[]::new);
        KieBase kBase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resources);
        this.kSession = kBase.newKieSession();
        this.rulesFired = new TrackingAgendaEventListener();
        this.kSession.addEventListener((AgendaEventListener)this.rulesFired);
        this.rulesFired.clear();
    }
}

