/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.SimplePerson;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class LogicalInsertFromCollectionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public LogicalInsertFromCollectionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testRemoveElement() {
        KieSession ksession = this.getKieBaseForTest().newKieSession();
        ArrayList<Integer> collection = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            collection.add(i);
        }
        FactHandle handle = ksession.insert(collection);
        ksession.fireAllRules();
        for (int i = 5; i > 1; --i) {
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo((long)i);
            collection.remove(collection.iterator().next());
            ksession.update(handle, collection);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo((long)(i - 1));
        }
    }

    @Test
    public void testAddElement() {
        KieSession ksession = this.getKieBaseForTest().newKieSession();
        ArrayList<Integer> collection = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            collection.add(i);
        }
        FactHandle handle = ksession.insert(collection);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(5L);
        collection.add(42);
        ksession.update(handle, collection);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(6L);
    }

    @Test
    public void testChangeElement() {
        KieSession ksession = this.getKieBaseForTest().newKieSession();
        ArrayList<SimplePerson> collection = new ArrayList<SimplePerson>();
        for (int i = 1; i < 5; ++i) {
            collection.add(new SimplePerson("Person " + i, 10 * i));
        }
        FactHandle handle = ksession.insert(collection);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(5L);
        ((SimplePerson)collection.iterator().next()).setAge(80);
        ksession.update(handle, collection);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(4L);
        ((SimplePerson)collection.iterator().next()).setAge(30);
        ksession.update(handle, collection);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(5L);
    }

    private KieBase getKieBaseForTest() {
        Resource drlResource = KieServices.Factory.get().getResources().newClassPathResource("logicalInsertFromCollectionTest.drl", this.getClass());
        return KieBaseUtil.getKieBaseFromKieModuleFromResources("org.drools.testcoverage.regression", this.kieBaseTestConfiguration, drlResource);
    }
}

