/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.testcoverage.common.util.FileUtil;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;

public final class KieBaseUtil {
    public static KieBase getDefaultKieBaseFromKieBuilder(KieBaseTestConfiguration kieBaseTestConfiguration, KieBuilder kbuilder) {
        if (kieBaseTestConfiguration.useCanonicalModel()) {
            KieBaseUtil.generateKieModuleForCanonicalModel(kbuilder);
        }
        return KieBaseUtil.getDefaultKieBaseFromKieModule(kbuilder.getKieModule());
    }

    public static KieBase getDefaultKieBaseFromKieModule(KieModule kmodule) {
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kmodule.getReleaseId());
    }

    public static KieBase getDefaultKieBaseFromReleaseId(ReleaseId id) {
        return KieBaseUtil.getKieBaseFromReleaseIdByName(id, null);
    }

    public static KieBase getKieBaseFromClasspathResources(Class classLoaderFromClass, KieBaseTestConfiguration kieBaseTestConfiguration, String ... resources) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources(kieBaseTestConfiguration, classLoaderFromClass, true, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBaseTestConfiguration, kieBuilder);
    }

    public static KieBase getKieBaseFromResources(KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, true, resources);
        if (kieBaseTestConfiguration.useCanonicalModel()) {
            KieBaseUtil.generateKieModuleForCanonicalModel(kieBuilder);
        }
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBaseTestConfiguration, kieBuilder);
    }

    private static void generateKieModuleForCanonicalModel(KieBuilder kieBuilder) {
        KieServices ks = KieServices.get();
        ReleaseId releaseId = kieBuilder.getKieModule().getReleaseId();
        InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModule();
        File kjarFile = FileUtil.bytesToTempKJARFile(releaseId, kieModule.getBytes(), ".jar");
        CanonicalKieModule zipKieModule = new CanonicalKieModule(releaseId, KieUtil.getDefaultKieModuleModel(ks), kjarFile);
        ks.getRepository().addKieModule((KieModule)zipKieModule);
    }

    public static KieBase getKieBaseFromDRLResources(KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieBaseUtil.generateDRLResourceTargetPath(resources);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, true, resources);
        return KieBaseUtil.getDefaultKieBaseFromKieBuilder(kieBaseTestConfiguration, kieBuilder);
    }

    private static void generateDRLResourceTargetPath(Resource[] resources) {
        for (int index = 0; index < resources.length; ++index) {
            resources[index].setTargetPath(String.format("rule-%d.drl", index));
        }
    }

    public static KieBase getKieBaseFromReleaseIdByName(ReleaseId id, String name) {
        KieContainer container = KieServices.Factory.get().newKieContainer(id);
        if (name == null) {
            return container.getKieBase();
        }
        return container.getKieBase(name);
    }

    public static KieBase getKieBaseAndBuildInstallModule(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieBaseUtil.getKieBaseAndBuildInstallModule(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources);
    }

    public static KieBase getKieBaseAndBuildInstallModule(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieModule kieModule = KieBaseUtil.getKieModuleAndBuildInstallModule(releaseId, kieBaseTestConfiguration, resources);
        return KieBaseUtil.getDefaultKieBaseFromReleaseId(kieModule.getReleaseId());
    }

    public static KieBase getKieBaseAndBuildInstallModuleFromDrl(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String drl) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return KieBaseUtil.getKieBaseAndBuildInstallModule(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, drlResource);
    }

    public static KieModule getKieModuleAndBuildInstallModuleFromDrl(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String drl) {
        return KieBaseUtil.getKieModuleAndBuildInstallModuleFromDrl(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, drl);
    }

    public static KieModule getKieModuleAndBuildInstallModuleFromDrl(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, String drl) {
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return KieBaseUtil.getKieModuleAndBuildInstallModule(releaseId, kieBaseTestConfiguration, drlResource);
    }

    public static KieModule getKieModuleAndBuildInstallModule(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieBaseUtil.getKieModuleAndBuildInstallModule(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources);
    }

    public static KieModule getKieModuleAndBuildInstallModule(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieModuleModel module = KieUtil.createKieModuleModel();
        kieBaseTestConfiguration.getKieBaseModel(module);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, releaseId, module, resources);
    }

    private KieBaseUtil() {
    }
}

