/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.testcoverage.common.util.FileUtil;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.KieCommands;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KieUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieUtil.class);

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, String groupId, KieModuleModel kieModuleModel, Resource ... resources) {
        ReleaseId releaseId = KieUtil.generateReleaseId(groupId);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, releaseId, kieModuleModel, resources);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, ReleaseId releaseId, KieModuleModel kieModuleModel, Resource ... resources) {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem fileSystem = KieUtil.getKieFileSystemWithKieModule(kieModuleModel, releaseId, resources);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem(kieBaseTestConfiguration, fileSystem, true);
        KieModule kieModule = builder.getKieModule();
        if (kieBaseTestConfiguration.useCanonicalModel()) {
            File kjarFile = FileUtil.bytesToTempKJARFile(releaseId, ((InternalKieModule)kieModule).getBytes(), ".jar");
            kieModule = new CanonicalKieModule(releaseId, kieModuleModel, kjarFile);
        }
        kieServices.getRepository().addKieModule(kieModule);
        return kieModule;
    }

    public static KieModuleModel createKieModuleModel() {
        KieServices kieServices = KieServices.Factory.get();
        return kieServices.newKieModuleModel();
    }

    public static KieFileSystem getKieFileSystemWithKieModule(KieModuleModel kieModuleModel, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem fileSystem = KieServices.Factory.get().newKieFileSystem();
        fileSystem.generateAndWritePomXML(releaseId);
        for (Resource resource : resources) {
            fileSystem.write(resource);
        }
        fileSystem.writeKModuleXML(kieModuleModel.toXML());
        return fileSystem;
    }

    public static KieBuilder getKieBuilderFromKieFileSystem(KieBaseTestConfiguration kieBaseTestConfiguration, KieFileSystem fileSystem, boolean failIfBuildError) {
        return KieUtil.getKieBuilderFromFileSystemWithResources(kieBaseTestConfiguration, fileSystem, failIfBuildError, new Resource[0]);
    }

    public static KieBuilder getKieBuilderFromResources(KieBaseTestConfiguration kieBaseTestConfiguration, boolean failIfBuildError, Resource ... resources) {
        return KieUtil.getKieBuilderFromFileSystemWithResources(kieBaseTestConfiguration, KieServices.Factory.get().newKieFileSystem(), failIfBuildError, resources);
    }

    public static KieModuleModel getDefaultKieModuleModel(KieServices ks) {
        KieModuleModel kproj = KieServices.get().newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("kbase").setDefault(true);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("ksession").setDefault(true);
        return kproj;
    }

    private static KieBuilder getKieBuilderFromFileSystemWithResources(KieBaseTestConfiguration kieBaseTestConfiguration, KieFileSystem kfs, boolean failIfBuildError, Resource ... resources) {
        for (Resource res : resources) {
            kfs.write(res);
        }
        KieBuilderImpl kbuilder = (KieBuilderImpl)KieServices.Factory.get().newKieBuilder(kfs);
        if (kieBaseTestConfiguration.useCanonicalModel()) {
            kbuilder.buildAll(CanonicalModelKieProject::new);
        } else {
            kbuilder.buildAll();
        }
        List msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.INFO});
        if (msgs.size() > 0) {
            LOGGER.info("KieBuilder information: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.WARNING})).size() > 0) {
            LOGGER.warn("KieBuilder warnings: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).size() > 0) {
            LOGGER.error("KieBuilder errors: {}", (Object)msgs.toString());
        }
        if (failIfBuildError) {
            ((ListAssert)Assertions.assertThat((List)msgs).as(msgs.toString(), new Object[0])).isEmpty();
        }
        return kbuilder;
    }

    public static ReleaseId generateReleaseId(String groupId) {
        KieServices kieServices = KieServices.Factory.get();
        return kieServices.newReleaseId(groupId, UUID.randomUUID().toString(), "1.0.0-SNAPSHOT");
    }

    public static KieBuilder getKieBuilderFromClasspathResources(KieBaseTestConfiguration kieBaseTestConfiguration, Class classLoaderFromClass, boolean failIfBuildError, String ... resources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String resource : resources) {
            result.add(KieServices.Factory.get().getResources().newClassPathResource(resource, classLoaderFromClass));
        }
        return KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, failIfBuildError, result.toArray(new Resource[0]));
    }

    public static Resource[] createResources(String drlFile, Class<?> clazz) {
        return new Resource[]{KieUtil.getResources().newClassPathResource(drlFile, clazz)};
    }

    public static Resource[] createResources(String drl) {
        Resource drlResource = KieUtil.getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return new Resource[]{drlResource};
    }

    public static final KieCommands getCommands() {
        return KieUtil.getServices().getCommands();
    }

    public static final KieResources getResources() {
        return KieUtil.getServices().getResources();
    }

    public static final KieServices getServices() {
        return KieServices.Factory.get();
    }

    private KieUtil() {
    }
}

