/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;

public final class TestParametersUtil {
    public static boolean TEST_CANONICAL_MODEL = false;

    public static Collection<Object[]> getKieBaseConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_CANONICAL_MODEL});
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY_CANONICAL_MODEL});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL});
        }
        return parameters;
    }

    public static Collection<Object[]> getKieBaseStreamConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL});
        }
        return parameters;
    }

    public static Collection<Object[]> getKieSessionConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieSessionTestConfiguration.STATEFUL_PSEUDO});
        parameters.add(new Object[]{KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieSessionTestConfiguration.STATELESS_REALTIME});
        return parameters;
    }

    public static Collection<Object[]> getKieBaseAndKieSessionConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY, KieSessionTestConfiguration.STATELESS_REALTIME});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATELESS_REALTIME});
        }
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY, KieSessionTestConfiguration.STATELESS_REALTIME});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATELESS_REALTIME});
        }
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        }
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        }
        return parameters;
    }

    public static Collection<Object[]> getKieBaseAndStatefulKieSessionConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        }
        return parameters;
    }

    public static Collection<Object[]> getStreamKieBaseAndStatefulKieSessionConfigurations() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY, KieSessionTestConfiguration.STATEFUL_REALTIME});
        parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        if (TEST_CANONICAL_MODEL) {
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_IDENTITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_REALTIME});
            parameters.add(new Object[]{KieBaseTestConfiguration.STREAM_EQUALITY_CANONICAL_MODEL, KieSessionTestConfiguration.STATEFUL_PSEUDO});
        }
        return parameters;
    }

    private TestParametersUtil() {
    }
}

