/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.listener.OrderListener;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class DeclarativeAgendaTest {
    @Test(timeout=10000L)
    public void testSimpleActivationBlock() {
        KieBase kbase = this.buildKieBase("declarative-agenda-simple-block.drl");
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        FactHandle fireRules = ksession.insert((Object)"fireRules");
        FactHandle fireBlockerRule = ksession.insert((Object)"fireBlockerRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected = new String[]{"blocker", "sales2"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
        ksession.removeEventListener((AgendaEventListener)listener);
        listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(0);
        ksession.removeEventListener((AgendaEventListener)listener);
        listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.delete(fireBlockerRule);
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(1);
        String[] expected3 = new String[]{"sales1"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected3[i]);
        }
        ksession.removeEventListener((AgendaEventListener)listener);
        listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(0);
        ksession.removeEventListener((AgendaEventListener)listener);
        listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.update(fireRules, (Object)"fireRules");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected5 = new String[]{"sales1", "sales2"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected5[i]);
        }
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testActivationBlock() {
        KieBase kbase = this.buildKieBase("declarative-agenda-block.drl");
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"startAgenda");
        ksession.insert((Object)"fireRules");
        FactHandle fireBlockerRule = ksession.insert((Object)"fireBlockerRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(6);
        String[] expected = new String[]{"startAgenda", "catering1", "sales1", "salesBlocker", "catering2", "salesBlocker"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
        ksession.delete(fireBlockerRule);
        ksession.removeEventListener((AgendaEventListener)listener);
        listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(1);
        String[] expected2 = new String[]{"sales2"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected2[i]);
        }
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testActivationCount() {
        KieBase kbase = this.buildKieBase("declarative-agenda-count.drl");
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        list.clear();
        ksession.delete(go1);
        ksession.fireAllRules();
        Assertions.assertThat(list).isEmpty();
        ksession.insert((Object)"go1");
        ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testUnblockAll() {
        KieBase kbase = this.buildKieBase("declarative-agenda-unblockall.drl");
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"fireRules");
        ksession.insert((Object)"fireBlockerRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected = new String[]{"salesBlocker", "salesBlocker"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
        ksession.insert((Object)"fireUnblockerRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(8);
        String[] expected2 = new String[]{"salesBlocker", "salesBlocker", "salesUnblocker", "sales1", "salesBlocker", "salesUnblocker", "sales2", "salesBlocker"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected2[i]);
        }
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testSimpleCancel() {
        KieBase kbase = this.buildKieBase("declarative-agenda-cancel.drl");
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"fireRules");
        ksession.insert((Object)"fireCancelRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected = new String[]{"salesCancel", "sales2"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testCancelWithUpdatingFacts() {
        KieBase kbase = this.buildKieBase("declarative-agenda-cancel.drl");
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        FactHandle fireRules = ksession.insert((Object)"fireRules");
        FactHandle fireCancelRule = ksession.insert((Object)"fireCancelRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected = new String[]{"salesCancel", "sales2"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected[i]);
        }
        ksession.removeEventListener((AgendaEventListener)listener);
        listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.update(fireCancelRule, (Object)"fireCancelRule");
        ksession.update(fireRules, (Object)"fireRules");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected2 = new String[]{"salesCancel", "sales2"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo((Object)expected2[i]);
        }
        ksession.dispose();
    }

    private KieBase buildKieBase(String drlFile) {
        KieServices kieServices = KieServices.Factory.get();
        Resource resource = kieServices.getResources().newClassPathResource(drlFile, this.getClass());
        KieModule kieModule = KieBaseUtil.getKieModuleAndBuildInstallModule("org.drools.testcoverage.functional", KieBaseTestConfiguration.CLOUD_IDENTITY, resource);
        KieBaseConfiguration kbconf = kieServices.newKieBaseConfiguration();
        kbconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        return kieServices.newKieContainer(kieModule.getReleaseId()).newKieBase(kbconf);
    }
}

