/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;

public class KieRepositoryTest {
    private static final String TEST_ARTIFACT_ID = "kie-repo-test";
    private static final String TEST_ARTIFACT_VERSION_RELEASE = "1.0.0";
    private static final String TEST_ARTIFACT_VERSION_SNAPSHOT = "1.0.0-SNAPSHOT";
    private KieServices kieServices;
    private static final String DRL = "package defaultKBase;\n rule testRule when then end\n";

    @Before
    public void initialize() throws IOException {
        this.kieServices = KieServices.Factory.get();
    }

    @Test
    public void testAddKieModuleRelease() {
        ReleaseId releaseId = this.kieServices.newReleaseId("org.drools.testcoverage", TEST_ARTIFACT_ID, TEST_ARTIFACT_VERSION_RELEASE);
        this.testKieModuleAddition(releaseId);
    }

    @Test
    public void testAddKieModuleSnapshot() {
        ReleaseId releaseId = this.kieServices.newReleaseId("org.drools.testcoverage", TEST_ARTIFACT_ID, TEST_ARTIFACT_VERSION_SNAPSHOT);
        this.testKieModuleAddition(releaseId);
    }

    private void testKieModuleAddition(ReleaseId releaseId) {
        KieRepository kieRepository = this.kieServices.getRepository();
        this.createKieModule(releaseId);
        Assertions.assertThat((Object)kieRepository.getKieModule(releaseId)).as("KieModule should be in KieRepository", new Object[0]).isNotNull();
    }

    @Test
    public void testRemoveKieModuleRelease() {
        ReleaseId releaseId = this.kieServices.newReleaseId("org.drools.testcoverage", TEST_ARTIFACT_ID, TEST_ARTIFACT_VERSION_RELEASE);
        this.testKieModuleRemoval(releaseId);
    }

    @Test
    public void testRemoveKieModuleSnapshot() {
        ReleaseId releaseId = this.kieServices.newReleaseId("org.drools.testcoverage", TEST_ARTIFACT_ID, TEST_ARTIFACT_VERSION_SNAPSHOT);
        this.testKieModuleRemoval(releaseId);
    }

    private void testKieModuleRemoval(ReleaseId releaseId) {
        KieRepository kieRepository = this.kieServices.getRepository();
        this.createKieModule(releaseId);
        Assertions.assertThat((Object)kieRepository.getKieModule(releaseId)).as("KieModule should be in KieRepository", new Object[0]).isNotNull();
        kieRepository.removeKieModule(releaseId);
        Assertions.assertThat((Object)kieRepository.getKieModule(releaseId)).as("KieModule should NOT be in KieRepository", new Object[0]).isNull();
    }

    private void createKieModule(ReleaseId releaseId) {
        KieModuleModel kmodule = this.kieServices.newKieModuleModel();
        kmodule.newKieBaseModel("defaultKBase").setDefault(true);
        KieFileSystem kfs = this.kieServices.newKieFileSystem();
        kfs.generateAndWritePomXML(releaseId);
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write("src/main/resources/defaultKBase/test.drl", this.kieServices.getResources().newByteArrayResource(DRL.getBytes()));
        KieBuilder kbuilder = this.kieServices.newKieBuilder(kfs);
        kbuilder.buildAll();
    }
}

