/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.utils.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildtimeUtil {
    private static Logger logger = LoggerFactory.getLogger(BuildtimeUtil.class);

    public static KieContainer createKieContainerFromResources(boolean useCanonicalModel, Resource ... resources) throws IOException {
        ReleaseId kJarReleaseId = BuildtimeUtil.createKJarFromResources(useCanonicalModel, resources);
        return KieServices.get().newKieContainer(kJarReleaseId);
    }

    public static ReleaseId createKJarFromResources(boolean useCanonicalModel, Resource ... resources) throws IOException {
        KieServices kieServices = KieServices.get();
        KieBuilder kieBuilder = BuildtimeUtil.getKieBuilderFromResources(kieServices.newKieFileSystem(), useCanonicalModel, resources);
        BuildtimeUtil.generateKJarFromKieBuilder(kieBuilder, useCanonicalModel);
        return kieBuilder.getKieModule().getReleaseId();
    }

    public static void generateKJarFromKieBuilder(KieBuilder kieBuilder, boolean useCanonicalModel) throws IOException {
        ReleaseId releaseId = kieBuilder.getKieModule().getReleaseId();
        InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModule();
        File kjarFile = BuildtimeUtil.bytesToTempFile(releaseId, kieModule.getBytes(), ".jar");
        Object zipKieModule = useCanonicalModel ? new CanonicalKieModule(releaseId, kieModule.getKieModuleModel(), kjarFile) : new ZipKieModule(releaseId, kieModule.getKieModuleModel(), kjarFile);
        KieServices.get().getRepository().addKieModule((KieModule)zipKieModule);
    }

    public static KieBuilder getKieBuilderFromResources(KieFileSystem kfs, boolean useCanonicalModel, Resource ... resources) {
        for (Resource res : resources) {
            kfs.write(res);
        }
        kfs.writeKModuleXML(BuildtimeUtil.getDefaultKieModuleModel(KieServices.get()).toXML());
        KieBuilderImpl kbuilder = (KieBuilderImpl)KieServices.Factory.get().newKieBuilder(kfs);
        if (useCanonicalModel) {
            kbuilder.buildAll(CanonicalModelKieProject::new);
        } else {
            kbuilder.buildAll();
        }
        List msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (msgs.size() > 0) {
            throw new IllegalArgumentException("KieBuilder errors: {\n" + msgs.toString() + "\n}");
        }
        return kbuilder;
    }

    public static KieBase createKieBaseFromResources(KieBaseConfiguration kieBaseConfiguration, Resource ... resources) {
        KieHelper kieHelper = new KieHelper();
        for (Resource resource : resources) {
            kieHelper.addResource(resource);
        }
        KieBase kieBase = kieHelper.build(kieBaseConfiguration);
        return kieBase;
    }

    public static KieBase createKieBaseFromDrl(String drl, KieBaseConfiguration kieBaseConfiguration) {
        KieBase kieBase = new KieHelper().addContent(drl, ResourceType.DRL).build(kieBaseConfiguration);
        return kieBase;
    }

    public static KieModuleModel getDefaultKieModuleModel(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("kbase").setDefault(true);
        kieBaseModel1.newKieSessionModel("ksession").setDefault(true);
        return kproj;
    }

    public static File bytesToTempFile(ReleaseId releaseId, byte[] bytes, String extension) throws IOException {
        File file = File.createTempFile("BTUtil", "");
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            fos.write(bytes);
        }
        return file;
    }

    private static void logDebug(String caption, String logContent) {
        logger.info("--------------------------------------------");
        logger.info(caption);
        logger.info("--------------------------------------------");
        logger.info(logContent);
        logger.info("--------------------------------------------");
    }

    private BuildtimeUtil() {
    }
}

