/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class FixedPatternTest {
    private KieSession ksession;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FixedPatternTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @After
    public void cleanup() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testFixedPattern() {
        Resource resource = KieServices.Factory.get().getResources().newClassPathResource("fixedPattern.xls", this.getClass());
        KieBuilder kbuilder = KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, resource);
        KieContainer kcontainer = KieServices.Factory.get().newKieContainer(kbuilder.getKieModule().getReleaseId());
        this.ksession = kcontainer.newKieSession();
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        this.ksession.insert((Object)1L);
        this.ksession.insert((Object)2);
        this.ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        ((ObjectAssert)Assertions.assertThat(list).first()).isEqualTo((Object)1L);
    }
}

