/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class NullInListInFromTest {
    private static final String DRL = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend\n";
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NullInListInFromTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullValueInFrom() throws Exception {
        Resource resource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(DRL));
        resource.setTargetPath("src/main/resources/rule.drl");
        KieBuilder kbuilder = KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, resource);
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder(this.kieBaseTestConfiguration, kbuilder);
        KieSession ksession = kbase.newKieSession();
        ArrayList<Integer> list = new ArrayList<Integer>();
        ksession.setGlobal("list", list);
        list.add(1);
        list.add(null);
        list.add(2);
        try {
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }
}

