/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.Properties;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.Session;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;

public final class KieSessionUtil {
    public static KieSessionConfiguration getKieSessionConfigurationWithClock(ClockTypeOption clockType, Properties sessionProperties) {
        KieSessionConfiguration conf = KieServices.Factory.get().newKieSessionConfiguration(sessionProperties);
        conf.setOption((KieSessionOption)clockType);
        return conf;
    }

    public static Session getKieSessionFromKieBaseModel(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, Resource ... resources) {
        KieModuleModel module = KieUtil.createKieModuleModel(kieBaseTestConfiguration.useAlphaNetworkCompiler());
        KieBaseModel kieBaseModel = kieBaseTestConfiguration.getKieBaseModel(module);
        kieSessionTestConfiguration.getKieSessionModel(kieBaseModel);
        KieModule kieModule = KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, moduleGroupId, module, resources);
        return KieSessionUtil.getDefaultKieSessionFromReleaseId(kieModule.getReleaseId(), kieSessionTestConfiguration.isStateful(), false);
    }

    public static Session getDefaultKieSessionFromReleaseId(ReleaseId releaseId, boolean stateful, boolean persisted) {
        return KieSessionUtil.getKieSessionFromReleaseIdByName(releaseId, null, stateful, persisted);
    }

    public static Session getKieSessionFromReleaseIdByName(ReleaseId releaseId, String name, boolean stateful, boolean persisted) {
        KieContainer container = KieServices.Factory.get().newKieContainer(releaseId);
        if (stateful) {
            return name == null ? new Session((KieRuntimeEventManager)container.newKieSession(), stateful, persisted) : new Session((KieRuntimeEventManager)container.newKieSession(name), stateful, persisted);
        }
        return name == null ? new Session((KieRuntimeEventManager)container.newStatelessKieSession(), stateful, persisted) : new Session((KieRuntimeEventManager)container.newStatelessKieSession(name), stateful, persisted);
    }

    private KieSessionUtil() {
    }
}

